/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPipelineReprocessingRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<StartPipelineReprocessingRequest.Builder, StartPipelineReprocessingRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(StartPipelineReprocessingRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(StartPipelineReprocessingRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(StartPipelineReprocessingRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<ChannelMessages> CHANNEL_MESSAGES_FIELD = SdkField
            .<ChannelMessages> builder(MarshallingType.SDK_POJO).memberName("channelMessages")
            .getter(getter(StartPipelineReprocessingRequest::channelMessages)).setter(setter(Builder::channelMessages))
            .constructor(ChannelMessages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMessages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, CHANNEL_MESSAGES_FIELD));

    private final String pipelineName;

    private final Instant startTime;

    private final Instant endTime;

    private final ChannelMessages channelMessages;

    private StartPipelineReprocessingRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.channelMessages = builder.channelMessages;
    }

    /**
     * <p>
     * The name of the pipeline on which to start reprocessing.
     * </p>
     * 
     * @return The name of the pipeline on which to start reprocessing.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The start time (inclusive) of raw message data that is reprocessed.
     * </p>
     * <p>
     * If you specify a value for the <code>startTime</code> parameter, you must not use the
     * <code>channelMessages</code> object.
     * </p>
     * 
     * @return The start time (inclusive) of raw message data that is reprocessed.</p>
     *         <p>
     *         If you specify a value for the <code>startTime</code> parameter, you must not use the
     *         <code>channelMessages</code> object.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time (exclusive) of raw message data that is reprocessed.
     * </p>
     * <p>
     * If you specify a value for the <code>endTime</code> parameter, you must not use the <code>channelMessages</code>
     * object.
     * </p>
     * 
     * @return The end time (exclusive) of raw message data that is reprocessed.</p>
     *         <p>
     *         If you specify a value for the <code>endTime</code> parameter, you must not use the
     *         <code>channelMessages</code> object.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Specifies one or more sets of channel messages that you want to reprocess.
     * </p>
     * <p>
     * If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code> and
     * <code>endTime</code>.
     * </p>
     * 
     * @return Specifies one or more sets of channel messages that you want to reprocess.</p>
     *         <p>
     *         If you use the <code>channelMessages</code> object, you must not specify a value for
     *         <code>startTime</code> and <code>endTime</code>.
     */
    public final ChannelMessages channelMessages() {
        return channelMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(channelMessages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineReprocessingRequest)) {
            return false;
        }
        StartPipelineReprocessingRequest other = (StartPipelineReprocessingRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(channelMessages(), other.channelMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPipelineReprocessingRequest").add("PipelineName", pipelineName())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ChannelMessages", channelMessages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "channelMessages":
            return Optional.ofNullable(clazz.cast(channelMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineReprocessingRequest, T> g) {
        return obj -> g.apply((StartPipelineReprocessingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartPipelineReprocessingRequest> {
        /**
         * <p>
         * The name of the pipeline on which to start reprocessing.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline on which to start reprocessing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The start time (inclusive) of raw message data that is reprocessed.
         * </p>
         * <p>
         * If you specify a value for the <code>startTime</code> parameter, you must not use the
         * <code>channelMessages</code> object.
         * </p>
         * 
         * @param startTime
         *        The start time (inclusive) of raw message data that is reprocessed.</p>
         *        <p>
         *        If you specify a value for the <code>startTime</code> parameter, you must not use the
         *        <code>channelMessages</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time (exclusive) of raw message data that is reprocessed.
         * </p>
         * <p>
         * If you specify a value for the <code>endTime</code> parameter, you must not use the
         * <code>channelMessages</code> object.
         * </p>
         * 
         * @param endTime
         *        The end time (exclusive) of raw message data that is reprocessed.</p>
         *        <p>
         *        If you specify a value for the <code>endTime</code> parameter, you must not use the
         *        <code>channelMessages</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Specifies one or more sets of channel messages that you want to reprocess.
         * </p>
         * <p>
         * If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code>
         * and <code>endTime</code>.
         * </p>
         * 
         * @param channelMessages
         *        Specifies one or more sets of channel messages that you want to reprocess.</p>
         *        <p>
         *        If you use the <code>channelMessages</code> object, you must not specify a value for
         *        <code>startTime</code> and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMessages(ChannelMessages channelMessages);

        /**
         * <p>
         * Specifies one or more sets of channel messages that you want to reprocess.
         * </p>
         * <p>
         * If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code>
         * and <code>endTime</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelMessages.Builder} avoiding the
         * need to create one manually via {@link ChannelMessages#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelMessages.Builder#build()} is called immediately and its
         * result is passed to {@link #channelMessages(ChannelMessages)}.
         * 
         * @param channelMessages
         *        a consumer that will call methods on {@link ChannelMessages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMessages(ChannelMessages)
         */
        default Builder channelMessages(Consumer<ChannelMessages.Builder> channelMessages) {
            return channelMessages(ChannelMessages.builder().applyMutation(channelMessages).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private Instant startTime;

        private Instant endTime;

        private ChannelMessages channelMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineReprocessingRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            startTime(model.startTime);
            endTime(model.endTime);
            channelMessages(model.channelMessages);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ChannelMessages.Builder getChannelMessages() {
            return channelMessages != null ? channelMessages.toBuilder() : null;
        }

        public final void setChannelMessages(ChannelMessages.BuilderImpl channelMessages) {
            this.channelMessages = channelMessages != null ? channelMessages.build() : null;
        }

        @Override
        public final Builder channelMessages(ChannelMessages channelMessages) {
            this.channelMessages = channelMessages;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineReprocessingRequest build() {
            return new StartPipelineReprocessingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
