/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineSummary> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(PipelineSummary.getter(PipelineSummary::pipelineName)).setter(PipelineSummary.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<List<ReprocessingSummary>> REPROCESSING_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reprocessingSummaries").getter(PipelineSummary.getter(PipelineSummary::reprocessingSummaries)).setter(PipelineSummary.setter(Builder::reprocessingSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reprocessingSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReprocessingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(PipelineSummary.getter(PipelineSummary::creationTime)).setter(PipelineSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(PipelineSummary.getter(PipelineSummary::lastUpdateTime)).setter(PipelineSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, REPROCESSING_SUMMARIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final List<ReprocessingSummary> reprocessingSummaries;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private PipelineSummary(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.reprocessingSummaries = builder.reprocessingSummaries;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final boolean hasReprocessingSummaries() {
        return this.reprocessingSummaries != null && !(this.reprocessingSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReprocessingSummary> reprocessingSummaries() {
        return this.reprocessingSummaries;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReprocessingSummaries() ? this.reprocessingSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && this.hasReprocessingSummaries() == other.hasReprocessingSummaries() && Objects.equals(this.reprocessingSummaries(), other.reprocessingSummaries()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineSummary").add("PipelineName", (Object)this.pipelineName()).add("ReprocessingSummaries", this.hasReprocessingSummaries() ? this.reprocessingSummaries() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "reprocessingSummaries": {
                return Optional.ofNullable(clazz.cast(this.reprocessingSummaries()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private List<ReprocessingSummary> reprocessingSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            this.pipelineName(model.pipelineName);
            this.reprocessingSummaries(model.reprocessingSummaries);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final List<ReprocessingSummary.Builder> getReprocessingSummaries() {
            List<ReprocessingSummary.Builder> result = ReprocessingSummariesCopier.copyToBuilder(this.reprocessingSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReprocessingSummaries(Collection<ReprocessingSummary.BuilderImpl> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copyFromBuilder(reprocessingSummaries);
        }

        @Override
        @Transient
        public final Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copy(reprocessingSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reprocessingSummaries(ReprocessingSummary ... reprocessingSummaries) {
            this.reprocessingSummaries(Arrays.asList(reprocessingSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder> ... reprocessingSummaries) {
            this.reprocessingSummaries(Stream.of(reprocessingSummaries).map(c -> (ReprocessingSummary)((ReprocessingSummary.Builder)ReprocessingSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineSummary> {
        public Builder pipelineName(String var1);

        public Builder reprocessingSummaries(Collection<ReprocessingSummary> var1);

        public Builder reprocessingSummaries(ReprocessingSummary ... var1);

        public Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

