/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutMessageResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<BatchPutMessageResponse.Builder, BatchPutMessageResponse> {
    private static final SdkField<List<BatchPutMessageErrorEntry>> BATCH_PUT_MESSAGE_ERROR_ENTRIES_FIELD = SdkField
            .<List<BatchPutMessageErrorEntry>> builder(MarshallingType.LIST)
            .memberName("batchPutMessageErrorEntries")
            .getter(getter(BatchPutMessageResponse::batchPutMessageErrorEntries))
            .setter(setter(Builder::batchPutMessageErrorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPutMessageErrorEntries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutMessageErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutMessageErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BATCH_PUT_MESSAGE_ERROR_ENTRIES_FIELD));

    private final List<BatchPutMessageErrorEntry> batchPutMessageErrorEntries;

    private BatchPutMessageResponse(BuilderImpl builder) {
        super(builder);
        this.batchPutMessageErrorEntries = builder.batchPutMessageErrorEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchPutMessageErrorEntries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBatchPutMessageErrorEntries() {
        return batchPutMessageErrorEntries != null && !(batchPutMessageErrorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any errors encountered when sending the messages to the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchPutMessageErrorEntries} method.
     * </p>
     * 
     * @return A list of any errors encountered when sending the messages to the channel.
     */
    public final List<BatchPutMessageErrorEntry> batchPutMessageErrorEntries() {
        return batchPutMessageErrorEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchPutMessageErrorEntries() ? batchPutMessageErrorEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMessageResponse)) {
            return false;
        }
        BatchPutMessageResponse other = (BatchPutMessageResponse) obj;
        return hasBatchPutMessageErrorEntries() == other.hasBatchPutMessageErrorEntries()
                && Objects.equals(batchPutMessageErrorEntries(), other.batchPutMessageErrorEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutMessageResponse")
                .add("BatchPutMessageErrorEntries", hasBatchPutMessageErrorEntries() ? batchPutMessageErrorEntries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchPutMessageErrorEntries":
            return Optional.ofNullable(clazz.cast(batchPutMessageErrorEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutMessageResponse, T> g) {
        return obj -> g.apply((BatchPutMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutMessageResponse> {
        /**
         * <p>
         * A list of any errors encountered when sending the messages to the channel.
         * </p>
         * 
         * @param batchPutMessageErrorEntries
         *        A list of any errors encountered when sending the messages to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPutMessageErrorEntries(Collection<BatchPutMessageErrorEntry> batchPutMessageErrorEntries);

        /**
         * <p>
         * A list of any errors encountered when sending the messages to the channel.
         * </p>
         * 
         * @param batchPutMessageErrorEntries
         *        A list of any errors encountered when sending the messages to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPutMessageErrorEntries(BatchPutMessageErrorEntry... batchPutMessageErrorEntries);

        /**
         * <p>
         * A list of any errors encountered when sending the messages to the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchPutMessageErrorEntry>.Builder}
         * avoiding the need to create one manually via {@link List<BatchPutMessageErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPutMessageErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #batchPutMessageErrorEntries(List<BatchPutMessageErrorEntry>)}
         * .
         * 
         * @param batchPutMessageErrorEntries
         *        a consumer that will call methods on {@link List<BatchPutMessageErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchPutMessageErrorEntries(List<BatchPutMessageErrorEntry>)
         */
        Builder batchPutMessageErrorEntries(Consumer<BatchPutMessageErrorEntry.Builder>... batchPutMessageErrorEntries);
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<BatchPutMessageErrorEntry> batchPutMessageErrorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutMessageResponse model) {
            super(model);
            batchPutMessageErrorEntries(model.batchPutMessageErrorEntries);
        }

        public final List<BatchPutMessageErrorEntry.Builder> getBatchPutMessageErrorEntries() {
            List<BatchPutMessageErrorEntry.Builder> result = BatchPutMessageErrorEntriesCopier
                    .copyToBuilder(this.batchPutMessageErrorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchPutMessageErrorEntries(
                Collection<BatchPutMessageErrorEntry.BuilderImpl> batchPutMessageErrorEntries) {
            this.batchPutMessageErrorEntries = BatchPutMessageErrorEntriesCopier.copyFromBuilder(batchPutMessageErrorEntries);
        }

        @Override
        @Transient
        public final Builder batchPutMessageErrorEntries(Collection<BatchPutMessageErrorEntry> batchPutMessageErrorEntries) {
            this.batchPutMessageErrorEntries = BatchPutMessageErrorEntriesCopier.copy(batchPutMessageErrorEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchPutMessageErrorEntries(BatchPutMessageErrorEntry... batchPutMessageErrorEntries) {
            batchPutMessageErrorEntries(Arrays.asList(batchPutMessageErrorEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchPutMessageErrorEntries(
                Consumer<BatchPutMessageErrorEntry.Builder>... batchPutMessageErrorEntries) {
            batchPutMessageErrorEntries(Stream.of(batchPutMessageErrorEntries)
                    .map(c -> BatchPutMessageErrorEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutMessageResponse build() {
            return new BatchPutMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
