/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to
 * a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Channel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ChannelStorage> STORAGE_FIELD = SdkField.<ChannelStorage> builder(MarshallingType.SDK_POJO)
            .memberName("storage").getter(getter(Channel::storage)).setter(setter(Builder::storage))
            .constructor(ChannelStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Channel::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Channel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(Channel::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Channel::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(Channel::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<Instant> LAST_MESSAGE_ARRIVAL_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastMessageArrivalTime").getter(getter(Channel::lastMessageArrivalTime))
            .setter(setter(Builder::lastMessageArrivalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMessageArrivalTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STORAGE_FIELD,
            ARN_FIELD, STATUS_FIELD, RETENTION_PERIOD_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD,
            LAST_MESSAGE_ARRIVAL_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ChannelStorage storage;

    private final String arn;

    private final String status;

    private final RetentionPeriod retentionPeriod;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final Instant lastMessageArrivalTime;

    private Channel(BuilderImpl builder) {
        this.name = builder.name;
        this.storage = builder.storage;
        this.arn = builder.arn;
        this.status = builder.status;
        this.retentionPeriod = builder.retentionPeriod;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastMessageArrivalTime = builder.lastMessageArrivalTime;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     * 
     * @return Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     *         <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *         You can't change this storage option after the channel is created.
     */
    public final ChannelStorage storage() {
        return storage;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */
    public final ChannelStatus status() {
        return ChannelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @return When the channel was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the channel was last updated.
     * </p>
     * 
     * @return When the channel was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @return The last time when a new message arrived in the channel.</p>
     *         <p>
     *         IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *         <code>lastMessageArrivalTime</code> value is an approximation.
     *         </p>
     *         <p>
     *         This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    public final Instant lastMessageArrivalTime() {
        return lastMessageArrivalTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastMessageArrivalTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(storage(), other.storage())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(lastMessageArrivalTime(), other.lastMessageArrivalTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Channel").add("Name", name()).add("Storage", storage()).add("Arn", arn())
                .add("Status", statusAsString()).add("RetentionPeriod", retentionPeriod()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).add("LastMessageArrivalTime", lastMessageArrivalTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "lastMessageArrivalTime":
            return Optional.ofNullable(clazz.cast(lastMessageArrivalTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param name
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * can't change this storage option after the channel is created.
         * </p>
         * 
         * @param storage
         *        Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         *        <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>
         *        . You can't change this storage option after the channel is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(ChannelStorage storage);

        /**
         * <p>
         * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * can't change this storage option after the channel is created.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelStorage.Builder} avoiding the need to
         * create one manually via {@link ChannelStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #storage(ChannelStorage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link ChannelStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(ChannelStorage)
         */
        default Builder storage(Consumer<ChannelStorage.Builder> storage) {
            return storage(ChannelStorage.builder().applyMutation(storage).build());
        }

        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param arn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the channel.
         * </p>
         * 
         * @param status
         *        The status of the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the channel.
         * </p>
         * 
         * @param status
         *        The status of the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(ChannelStatus status);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * When the channel was created.
         * </p>
         * 
         * @param creationTime
         *        When the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the channel was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        When the channel was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The last time when a new message arrived in the channel.
         * </p>
         * <p>
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the
         * <code>lastMessageArrivalTime</code> value is an approximation.
         * </p>
         * <p>
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         * </p>
         * 
         * @param lastMessageArrivalTime
         *        The last time when a new message arrived in the channel.</p>
         *        <p>
         *        IoT Analytics updates this value at most once per minute for one channel. Hence, the
         *        <code>lastMessageArrivalTime</code> value is an approximation.
         *        </p>
         *        <p>
         *        This feature only applies to messages that arrived in the data store after October 23, 2020.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMessageArrivalTime(Instant lastMessageArrivalTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ChannelStorage storage;

        private String arn;

        private String status;

        private RetentionPeriod retentionPeriod;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private Instant lastMessageArrivalTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            name(model.name);
            storage(model.storage);
            arn(model.arn);
            status(model.status);
            retentionPeriod(model.retentionPeriod);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            lastMessageArrivalTime(model.lastMessageArrivalTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ChannelStorage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(ChannelStorage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        @Transient
        public final Builder storage(ChannelStorage storage) {
            this.storage = storage;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final Instant getLastMessageArrivalTime() {
            return lastMessageArrivalTime;
        }

        public final void setLastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
        }

        @Override
        @Transient
        public final Builder lastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
            return this;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
