/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about dataset contents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetContentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetContentSummary.Builder, DatasetContentSummary> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(DatasetContentSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<DatasetContentStatus> STATUS_FIELD = SdkField
            .<DatasetContentStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(DatasetContentSummary::status)).setter(setter(Builder::status))
            .constructor(DatasetContentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DatasetContentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> SCHEDULE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("scheduleTime").getter(getter(DatasetContentSummary::scheduleTime)).setter(setter(Builder::scheduleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime").getter(getter(DatasetContentSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD, SCHEDULE_TIME_FIELD, COMPLETION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private final DatasetContentStatus status;

    private final Instant creationTime;

    private final Instant scheduleTime;

    private final Instant completionTime;

    private DatasetContentSummary(BuilderImpl builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.scheduleTime = builder.scheduleTime;
        this.completionTime = builder.completionTime;
    }

    /**
     * <p>
     * The version of the dataset contents.
     * </p>
     * 
     * @return The version of the dataset contents.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The status of the dataset contents.
     * </p>
     * 
     * @return The status of the dataset contents.
     */
    public final DatasetContentStatus status() {
        return status;
    }

    /**
     * <p>
     * The actual time the creation of the dataset contents was started.
     * </p>
     * 
     * @return The actual time the creation of the dataset contents was started.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the creation of the dataset contents was scheduled to start.
     * </p>
     * 
     * @return The time the creation of the dataset contents was scheduled to start.
     */
    public final Instant scheduleTime() {
        return scheduleTime;
    }

    /**
     * <p>
     * The time the dataset content status was updated to SUCCEEDED or FAILED.
     * </p>
     * 
     * @return The time the dataset content status was updated to SUCCEEDED or FAILED.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentSummary)) {
            return false;
        }
        DatasetContentSummary other = (DatasetContentSummary) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(status(), other.status())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(scheduleTime(), other.scheduleTime())
                && Objects.equals(completionTime(), other.completionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetContentSummary").add("Version", version()).add("Status", status())
                .add("CreationTime", creationTime()).add("ScheduleTime", scheduleTime()).add("CompletionTime", completionTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "scheduleTime":
            return Optional.ofNullable(clazz.cast(scheduleTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentSummary, T> g) {
        return obj -> g.apply((DatasetContentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetContentSummary> {
        /**
         * <p>
         * The version of the dataset contents.
         * </p>
         * 
         * @param version
         *        The version of the dataset contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The status of the dataset contents.
         * </p>
         * 
         * @param status
         *        The status of the dataset contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(DatasetContentStatus status);

        /**
         * <p>
         * The status of the dataset contents.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetContentStatus.Builder} avoiding the need
         * to create one manually via {@link DatasetContentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetContentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(DatasetContentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link DatasetContentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(DatasetContentStatus)
         */
        default Builder status(Consumer<DatasetContentStatus.Builder> status) {
            return status(DatasetContentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The actual time the creation of the dataset contents was started.
         * </p>
         * 
         * @param creationTime
         *        The actual time the creation of the dataset contents was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the creation of the dataset contents was scheduled to start.
         * </p>
         * 
         * @param scheduleTime
         *        The time the creation of the dataset contents was scheduled to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleTime(Instant scheduleTime);

        /**
         * <p>
         * The time the dataset content status was updated to SUCCEEDED or FAILED.
         * </p>
         * 
         * @param completionTime
         *        The time the dataset content status was updated to SUCCEEDED or FAILED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private DatasetContentStatus status;

        private Instant creationTime;

        private Instant scheduleTime;

        private Instant completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentSummary model) {
            version(model.version);
            status(model.status);
            creationTime(model.creationTime);
            scheduleTime(model.scheduleTime);
            completionTime(model.completionTime);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final DatasetContentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(DatasetContentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(DatasetContentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getScheduleTime() {
            return scheduleTime;
        }

        public final void setScheduleTime(Instant scheduleTime) {
            this.scheduleTime = scheduleTime;
        }

        @Override
        @Transient
        public final Builder scheduleTime(Instant scheduleTime) {
            this.scheduleTime = scheduleTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        @Transient
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        @Override
        public DatasetContentSummary build() {
            return new DatasetContentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
