/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage,
 * <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is
 * <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreStorage implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreStorage.Builder, DatastoreStorage> {
    private static final SdkField<ServiceManagedDatastoreS3Storage> SERVICE_MANAGED_S3_FIELD = SdkField
            .<ServiceManagedDatastoreS3Storage> builder(MarshallingType.SDK_POJO).memberName("serviceManagedS3")
            .getter(getter(DatastoreStorage::serviceManagedS3)).setter(setter(Builder::serviceManagedS3))
            .constructor(ServiceManagedDatastoreS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()).build();

    private static final SdkField<CustomerManagedDatastoreS3Storage> CUSTOMER_MANAGED_S3_FIELD = SdkField
            .<CustomerManagedDatastoreS3Storage> builder(MarshallingType.SDK_POJO).memberName("customerManagedS3")
            .getter(getter(DatastoreStorage::customerManagedS3)).setter(setter(Builder::customerManagedS3))
            .constructor(CustomerManagedDatastoreS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()).build();

    private static final SdkField<DatastoreIotSiteWiseMultiLayerStorage> IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD = SdkField
            .<DatastoreIotSiteWiseMultiLayerStorage> builder(MarshallingType.SDK_POJO)
            .memberName("iotSiteWiseMultiLayerStorage")
            .getter(getter(DatastoreStorage::iotSiteWiseMultiLayerStorage))
            .setter(setter(Builder::iotSiteWiseMultiLayerStorage))
            .constructor(DatastoreIotSiteWiseMultiLayerStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseMultiLayerStorage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD,
            CUSTOMER_MANAGED_S3_FIELD, IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceManagedDatastoreS3Storage serviceManagedS3;

    private final CustomerManagedDatastoreS3Storage customerManagedS3;

    private final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;

    private DatastoreStorage(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
        this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
    }

    /**
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
     * storage after your data store is created.
     * </p>
     * 
     * @return Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon
     *         S3 storage after your data store is created.
     */
    public final ServiceManagedDatastoreS3Storage serviceManagedS3() {
        return serviceManagedS3;
    }

    /**
     * <p>
     * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
     * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @return S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter
     *         is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    public final CustomerManagedDatastoreS3Storage customerManagedS3() {
        return customerManagedS3;
    }

    /**
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of
     * Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @return Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
     *         choice of Amazon S3 storage after your data store is created.
     */
    public final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage() {
        return iotSiteWiseMultiLayerStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseMultiLayerStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorage)) {
            return false;
        }
        DatastoreStorage other = (DatastoreStorage) obj;
        return Objects.equals(serviceManagedS3(), other.serviceManagedS3())
                && Objects.equals(customerManagedS3(), other.customerManagedS3())
                && Objects.equals(iotSiteWiseMultiLayerStorage(), other.iotSiteWiseMultiLayerStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreStorage").add("ServiceManagedS3", serviceManagedS3())
                .add("CustomerManagedS3", customerManagedS3())
                .add("IotSiteWiseMultiLayerStorage", iotSiteWiseMultiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceManagedS3":
            return Optional.ofNullable(clazz.cast(serviceManagedS3()));
        case "customerManagedS3":
            return Optional.ofNullable(clazz.cast(customerManagedS3()));
        case "iotSiteWiseMultiLayerStorage":
            return Optional.ofNullable(clazz.cast(iotSiteWiseMultiLayerStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorage, T> g) {
        return obj -> g.apply((DatastoreStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreStorage> {
        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
         * storage after your data store is created.
         * </p>
         * 
         * @param serviceManagedS3
         *        Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of
         *        Amazon S3 storage after your data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3);

        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
         * storage after your data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceManagedDatastoreS3Storage.Builder}
         * avoiding the need to create one manually via {@link ServiceManagedDatastoreS3Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceManagedDatastoreS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceManagedS3(ServiceManagedDatastoreS3Storage)}.
         * 
         * @param serviceManagedS3
         *        a consumer that will call methods on {@link ServiceManagedDatastoreS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedS3(ServiceManagedDatastoreS3Storage)
         */
        default Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
            return serviceManagedS3(ServiceManagedDatastoreS3Storage.builder().applyMutation(serviceManagedS3).build());
        }

        /**
         * <p>
         * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
         * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
         * </p>
         * 
         * @param customerManagedS3
         *        S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code>
         *        parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3);

        /**
         * <p>
         * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
         * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerManagedDatastoreS3Storage.Builder}
         * avoiding the need to create one manually via {@link CustomerManagedDatastoreS3Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerManagedDatastoreS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #customerManagedS3(CustomerManagedDatastoreS3Storage)}.
         * 
         * @param customerManagedS3
         *        a consumer that will call methods on {@link CustomerManagedDatastoreS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3(CustomerManagedDatastoreS3Storage)
         */
        default Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
            return customerManagedS3(CustomerManagedDatastoreS3Storage.builder().applyMutation(customerManagedS3).build());
        }

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice
         * of Amazon S3 storage after your data store is created.
         * </p>
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
         *        choice of Amazon S3 storage after your data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage);

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice
         * of Amazon S3 storage after your data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link DatastoreIotSiteWiseMultiLayerStorage.Builder}
         * avoiding the need to create one manually via {@link DatastoreIotSiteWiseMultiLayerStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatastoreIotSiteWiseMultiLayerStorage.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage)}.
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        a consumer that will call methods on {@link DatastoreIotSiteWiseMultiLayerStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage)
         */
        default Builder iotSiteWiseMultiLayerStorage(
                Consumer<DatastoreIotSiteWiseMultiLayerStorage.Builder> iotSiteWiseMultiLayerStorage) {
            return iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage.builder()
                    .applyMutation(iotSiteWiseMultiLayerStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedDatastoreS3Storage serviceManagedS3;

        private CustomerManagedDatastoreS3Storage customerManagedS3;

        private DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorage model) {
            serviceManagedS3(model.serviceManagedS3);
            customerManagedS3(model.customerManagedS3);
            iotSiteWiseMultiLayerStorage(model.iotSiteWiseMultiLayerStorage);
        }

        public final ServiceManagedDatastoreS3Storage.Builder getServiceManagedS3() {
            return serviceManagedS3 != null ? serviceManagedS3.toBuilder() : null;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3Storage.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final CustomerManagedDatastoreS3Storage.Builder getCustomerManagedS3() {
            return customerManagedS3 != null ? customerManagedS3.toBuilder() : null;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3Storage.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        @Override
        @Transient
        public final Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final DatastoreIotSiteWiseMultiLayerStorage.Builder getIotSiteWiseMultiLayerStorage() {
            return iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.toBuilder() : null;
        }

        public final void setIotSiteWiseMultiLayerStorage(
                DatastoreIotSiteWiseMultiLayerStorage.BuilderImpl iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
            return this;
        }

        @Override
        public DatastoreStorage build() {
            return new DatastoreStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
