/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelsResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<ListChannelsResponse.Builder, ListChannelsResponse> {
    private static final SdkField<List<ChannelSummary>> CHANNEL_SUMMARIES_FIELD = SdkField
            .<List<ChannelSummary>> builder(MarshallingType.LIST)
            .memberName("channelSummaries")
            .getter(getter(ListChannelsResponse::channelSummaries))
            .setter(setter(Builder::channelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListChannelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ChannelSummary> channelSummaries;

    private final String nextToken;

    private ListChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channelSummaries = builder.channelSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelSummaries() {
        return channelSummaries != null && !(channelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ChannelSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelSummaries} method.
     * </p>
     * 
     * @return A list of <code>ChannelSummary</code> objects.
     */
    public final List<ChannelSummary> channelSummaries() {
        return channelSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelSummaries() ? channelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsResponse)) {
            return false;
        }
        ListChannelsResponse other = (ListChannelsResponse) obj;
        return hasChannelSummaries() == other.hasChannelSummaries()
                && Objects.equals(channelSummaries(), other.channelSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelsResponse")
                .add("ChannelSummaries", hasChannelSummaries() ? channelSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelSummaries":
            return Optional.ofNullable(clazz.cast(channelSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsResponse, T> g) {
        return obj -> g.apply((ListChannelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChannelsResponse> {
        /**
         * <p>
         * A list of <code>ChannelSummary</code> objects.
         * </p>
         * 
         * @param channelSummaries
         *        A list of <code>ChannelSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSummaries(Collection<ChannelSummary> channelSummaries);

        /**
         * <p>
         * A list of <code>ChannelSummary</code> objects.
         * </p>
         * 
         * @param channelSummaries
         *        A list of <code>ChannelSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSummaries(ChannelSummary... channelSummaries);

        /**
         * <p>
         * A list of <code>ChannelSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChannelSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ChannelSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #channelSummaries(List<ChannelSummary>)}.
         * 
         * @param channelSummaries
         *        a consumer that will call methods on {@link List<ChannelSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelSummaries(List<ChannelSummary>)
         */
        Builder channelSummaries(Consumer<ChannelSummary.Builder>... channelSummaries);

        /**
         * <p>
         * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<ChannelSummary> channelSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsResponse model) {
            super(model);
            channelSummaries(model.channelSummaries);
            nextToken(model.nextToken);
        }

        public final List<ChannelSummary.Builder> getChannelSummaries() {
            List<ChannelSummary.Builder> result = ChannelSummariesCopier.copyToBuilder(this.channelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelSummaries(Collection<ChannelSummary.BuilderImpl> channelSummaries) {
            this.channelSummaries = ChannelSummariesCopier.copyFromBuilder(channelSummaries);
        }

        @Override
        @Transient
        public final Builder channelSummaries(Collection<ChannelSummary> channelSummaries) {
            this.channelSummaries = ChannelSummariesCopier.copy(channelSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelSummaries(ChannelSummary... channelSummaries) {
            channelSummaries(Arrays.asList(channelSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelSummaries(Consumer<ChannelSummary.Builder>... channelSummaries) {
            channelSummaries(Stream.of(channelSummaries).map(c -> ChannelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelsResponse build() {
            return new ListChannelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
