/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(Message::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload").getter(getter(Message::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final SdkBytes payload;

    private Message(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.
     * </p>
     * 
     * @return The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch
     *         sent.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in
     * which case you must decode it by means of a pipeline activity.
     * </p>
     * 
     * @return The payload of the message. This can be a JSON string or a base64-encoded string representing binary
     *         data, in which case you must decode it by means of a pipeline activity.
     */
    public final SdkBytes payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("MessageId", messageId()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.
         * </p>
         * 
         * @param messageId
         *        The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch
         *        sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in
         * which case you must decode it by means of a pipeline activity.
         * </p>
         * 
         * @param payload
         *        The payload of the message. This can be a JSON string or a base64-encoded string representing binary
         *        data, in which case you must decode it by means of a pipeline activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            messageId(model.messageId);
            payload(model.payload);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        @Transient
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
