/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A partition dimension defined by a timestamp attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampPartition implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestampPartition.Builder, TimestampPartition> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeName").getter(getter(TimestampPartition::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestampFormat").getter(getter(TimestampPartition::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            TIMESTAMP_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String timestampFormat;

    private TimestampPartition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.timestampFormat = builder.timestampFormat;
    }

    /**
     * <p>
     * The attribute name of the partition defined by a timestamp.
     * </p>
     * 
     * @return The attribute name of the partition defined by a timestamp.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1,
     * 1970 at midnight UTC time).
     * </p>
     * 
     * @return The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch
     *         (January 1, 1970 at midnight UTC time).
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampPartition)) {
            return false;
        }
        TimestampPartition other = (TimestampPartition) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(timestampFormat(), other.timestampFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampPartition").add("AttributeName", attributeName())
                .add("TimestampFormat", timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "timestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampPartition, T> g) {
        return obj -> g.apply((TimestampPartition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampPartition> {
        /**
         * <p>
         * The attribute name of the partition defined by a timestamp.
         * </p>
         * 
         * @param attributeName
         *        The attribute name of the partition defined by a timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch
         * (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param timestampFormat
         *        The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch
         *        (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampPartition model) {
            attributeName(model.attributeName);
            timestampFormat(model.timestampFormat);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        @Transient
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        @Override
        public TimestampPartition build() {
            return new TimestampPartition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
