/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetContentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetContentSummary> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(DatasetContentSummary.getter(DatasetContentSummary::version)).setter(DatasetContentSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<DatasetContentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(DatasetContentSummary.getter(DatasetContentSummary::status)).setter(DatasetContentSummary.setter(Builder::status)).constructor(DatasetContentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DatasetContentSummary.getter(DatasetContentSummary::creationTime)).setter(DatasetContentSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> SCHEDULE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scheduleTime").getter(DatasetContentSummary.getter(DatasetContentSummary::scheduleTime)).setter(DatasetContentSummary.setter(Builder::scheduleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(DatasetContentSummary.getter(DatasetContentSummary::completionTime)).setter(DatasetContentSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, SCHEDULE_TIME_FIELD, COMPLETION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final DatasetContentStatus status;
    private final Instant creationTime;
    private final Instant scheduleTime;
    private final Instant completionTime;

    private DatasetContentSummary(BuilderImpl builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.scheduleTime = builder.scheduleTime;
        this.completionTime = builder.completionTime;
    }

    public final String version() {
        return this.version;
    }

    public final DatasetContentStatus status() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant scheduleTime() {
        return this.scheduleTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentSummary)) {
            return false;
        }
        DatasetContentSummary other = (DatasetContentSummary)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.scheduleTime(), other.scheduleTime()) && Objects.equals(this.completionTime(), other.completionTime());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetContentSummary").add("Version", (Object)this.version()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("ScheduleTime", (Object)this.scheduleTime()).add("CompletionTime", (Object)this.completionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "scheduleTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleTime()));
            }
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentSummary, T> g) {
        return obj -> g.apply((DatasetContentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private DatasetContentStatus status;
        private Instant creationTime;
        private Instant scheduleTime;
        private Instant completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentSummary model) {
            this.version(model.version);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.scheduleTime(model.scheduleTime);
            this.completionTime(model.completionTime);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final DatasetContentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(DatasetContentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(DatasetContentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getScheduleTime() {
            return this.scheduleTime;
        }

        public final void setScheduleTime(Instant scheduleTime) {
            this.scheduleTime = scheduleTime;
        }

        @Override
        @Transient
        public final Builder scheduleTime(Instant scheduleTime) {
            this.scheduleTime = scheduleTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        @Transient
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public DatasetContentSummary build() {
            return new DatasetContentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetContentSummary> {
        public Builder version(String var1);

        public Builder status(DatasetContentStatus var1);

        default public Builder status(Consumer<DatasetContentStatus.Builder> status) {
            return this.status((DatasetContentStatus)((DatasetContentStatus.Builder)DatasetContentStatus.builder().applyMutation(status)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder scheduleTime(Instant var1);

        public Builder completionTime(Instant var1);
    }
}

