/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatasetActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetActionSummary> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(DatasetActionSummary.getter(DatasetActionSummary::actionName)).setter(DatasetActionSummary.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(DatasetActionSummary.getter(DatasetActionSummary::actionTypeAsString)).setter(DatasetActionSummary.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, ACTION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final String actionType;

    private DatasetActionSummary(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.actionType = builder.actionType;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final DatasetActionType actionType() {
        return DatasetActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetActionSummary)) {
            return false;
        }
        DatasetActionSummary other = (DatasetActionSummary)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetActionSummary").add("ActionName", (Object)this.actionName()).add("ActionType", (Object)this.actionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetActionSummary, T> g) {
        return obj -> g.apply((DatasetActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private String actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetActionSummary model) {
            this.actionName(model.actionName);
            this.actionType(model.actionType);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(DatasetActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public DatasetActionSummary build() {
            return new DatasetActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetActionSummary> {
        public Builder actionName(String var1);

        public Builder actionType(String var1);

        public Builder actionType(DatasetActionType var1);
    }
}

