/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pipeline implements SdkPojo, Serializable, ToCopyableBuilder<Pipeline.Builder, Pipeline> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Pipeline::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Pipeline::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<PipelineActivity>> ACTIVITIES_FIELD = SdkField
            .<List<PipelineActivity>> builder(MarshallingType.LIST)
            .memberName("activities")
            .getter(getter(Pipeline::activities))
            .setter(setter(Builder::activities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineActivity> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineActivity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReprocessingSummary>> REPROCESSING_SUMMARIES_FIELD = SdkField
            .<List<ReprocessingSummary>> builder(MarshallingType.LIST)
            .memberName("reprocessingSummaries")
            .getter(getter(Pipeline::reprocessingSummaries))
            .setter(setter(Builder::reprocessingSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reprocessingSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReprocessingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReprocessingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Pipeline::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(Pipeline::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ACTIVITIES_FIELD, REPROCESSING_SUMMARIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final List<PipelineActivity> activities;

    private final List<ReprocessingSummary> reprocessingSummaries;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private Pipeline(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.activities = builder.activities;
        this.reprocessingSummaries = builder.reprocessingSummaries;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the pipeline.
     * </p>
     * 
     * @return The ARN of the pipeline.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Activities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActivities() {
        return activities != null && !(activities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The activities that perform transformations on the messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivities} method.
     * </p>
     * 
     * @return The activities that perform transformations on the messages.
     */
    public final List<PipelineActivity> activities() {
        return activities;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReprocessingSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReprocessingSummaries() {
        return reprocessingSummaries != null && !(reprocessingSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of information about the pipeline reprocessing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReprocessingSummaries} method.
     * </p>
     * 
     * @return A summary of information about the pipeline reprocessing.
     */
    public final List<ReprocessingSummary> reprocessingSummaries() {
        return reprocessingSummaries;
    }

    /**
     * <p>
     * When the pipeline was created.
     * </p>
     * 
     * @return When the pipeline was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the pipeline was updated.
     * </p>
     * 
     * @return The last time the pipeline was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasActivities() ? activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReprocessingSummaries() ? reprocessingSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && hasActivities() == other.hasActivities() && Objects.equals(activities(), other.activities())
                && hasReprocessingSummaries() == other.hasReprocessingSummaries()
                && Objects.equals(reprocessingSummaries(), other.reprocessingSummaries())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Pipeline").add("Name", name()).add("Arn", arn())
                .add("Activities", hasActivities() ? activities() : null)
                .add("ReprocessingSummaries", hasReprocessingSummaries() ? reprocessingSummaries() : null)
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "activities":
            return Optional.ofNullable(clazz.cast(activities()));
        case "reprocessingSummaries":
            return Optional.ofNullable(clazz.cast(reprocessingSummaries()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pipeline> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param name
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the pipeline.
         * </p>
         * 
         * @param arn
         *        The ARN of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The activities that perform transformations on the messages.
         * </p>
         * 
         * @param activities
         *        The activities that perform transformations on the messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<PipelineActivity> activities);

        /**
         * <p>
         * The activities that perform transformations on the messages.
         * </p>
         * 
         * @param activities
         *        The activities that perform transformations on the messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(PipelineActivity... activities);

        /**
         * <p>
         * The activities that perform transformations on the messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.PipelineActivity.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotanalytics.model.PipelineActivity#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.PipelineActivity.Builder#build()} is called
         * immediately and its result is passed to {@link #activities(List<PipelineActivity>)}.
         * 
         * @param activities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.PipelineActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activities(java.util.Collection<PipelineActivity>)
         */
        Builder activities(Consumer<PipelineActivity.Builder>... activities);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * 
         * @param reprocessingSummaries
         *        A summary of information about the pipeline reprocessing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * 
         * @param reprocessingSummaries
         *        A summary of information about the pipeline reprocessing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reprocessingSummaries(ReprocessingSummary... reprocessingSummaries);

        /**
         * <p>
         * A summary of information about the pipeline reprocessing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #reprocessingSummaries(List<ReprocessingSummary>)}.
         * 
         * @param reprocessingSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reprocessingSummaries(java.util.Collection<ReprocessingSummary>)
         */
        Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder>... reprocessingSummaries);

        /**
         * <p>
         * When the pipeline was created.
         * </p>
         * 
         * @param creationTime
         *        When the pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the pipeline was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the pipeline was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private List<PipelineActivity> activities = DefaultSdkAutoConstructList.getInstance();

        private List<ReprocessingSummary> reprocessingSummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            name(model.name);
            arn(model.arn);
            activities(model.activities);
            reprocessingSummaries(model.reprocessingSummaries);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<PipelineActivity.Builder> getActivities() {
            List<PipelineActivity.Builder> result = PipelineActivitiesCopier.copyToBuilder(this.activities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivities(Collection<PipelineActivity.BuilderImpl> activities) {
            this.activities = PipelineActivitiesCopier.copyFromBuilder(activities);
        }

        @Override
        public final Builder activities(Collection<PipelineActivity> activities) {
            this.activities = PipelineActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(PipelineActivity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<PipelineActivity.Builder>... activities) {
            activities(Stream.of(activities).map(c -> PipelineActivity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReprocessingSummary.Builder> getReprocessingSummaries() {
            List<ReprocessingSummary.Builder> result = ReprocessingSummariesCopier.copyToBuilder(this.reprocessingSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReprocessingSummaries(Collection<ReprocessingSummary.BuilderImpl> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copyFromBuilder(reprocessingSummaries);
        }

        @Override
        public final Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copy(reprocessingSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(ReprocessingSummary... reprocessingSummaries) {
            reprocessingSummaries(Arrays.asList(reprocessingSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder>... reprocessingSummaries) {
            reprocessingSummaries(Stream.of(reprocessingSummaries)
                    .map(c -> ReprocessingSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public Pipeline build() {
            return new Pipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
