/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatasetSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetSummary;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetsResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private static final SdkField<List<DatasetSummary>> DATASET_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetSummaries").getter(ListDatasetsResponse.getter(ListDatasetsResponse::datasetSummaries)).setter(ListDatasetsResponse.setter(Builder::datasetSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatasetsResponse.getter(ListDatasetsResponse::nextToken)).setter(ListDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatasetSummary> datasetSummaries;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetSummaries = builder.datasetSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetSummaries() {
        return this.datasetSummaries != null && !(this.datasetSummaries instanceof SdkAutoConstructList);
    }

    public final List<DatasetSummary> datasetSummaries() {
        return this.datasetSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetSummaries() ? this.datasetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        return this.hasDatasetSummaries() == other.hasDatasetSummaries() && Objects.equals(this.datasetSummaries(), other.datasetSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetsResponse").add("DatasetSummaries", this.hasDatasetSummaries() ? this.datasetSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetSummaries": {
                return Optional.ofNullable(clazz.cast(this.datasetSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetsResponse, T> g) {
        return obj -> g.apply((ListDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<DatasetSummary> datasetSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            this.datasetSummaries(model.datasetSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetSummary.Builder> getDatasetSummaries() {
            List<DatasetSummary.Builder> result = DatasetSummariesCopier.copyToBuilder(this.datasetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetSummaries(Collection<DatasetSummary.BuilderImpl> datasetSummaries) {
            this.datasetSummaries = DatasetSummariesCopier.copyFromBuilder(datasetSummaries);
        }

        @Override
        public final Builder datasetSummaries(Collection<DatasetSummary> datasetSummaries) {
            this.datasetSummaries = DatasetSummariesCopier.copy(datasetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetSummaries(DatasetSummary ... datasetSummaries) {
            this.datasetSummaries(Arrays.asList(datasetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetSummaries(Consumer<DatasetSummary.Builder> ... datasetSummaries) {
            this.datasetSummaries(Stream.of(datasetSummaries).map(c -> (DatasetSummary)((DatasetSummary.Builder)DatasetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasetSummaries(Collection<DatasetSummary> var1);

        public Builder datasetSummaries(DatasetSummary ... var1);

        public Builder datasetSummaries(Consumer<DatasetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

