/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest;
import software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeletePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest;
import software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse;
import software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest;
import software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse;
import software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest;
import software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse;
import software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.TagResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsPublisher;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher;
import software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher;

/**
 * Service client for accessing AWS IoT Analytics asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * IoT Analytics allows you to collect large amounts of device data, process messages, and store them. You can then
 * query the data and run sophisticated analytics on it. IoT Analytics enables advanced data exploration through
 * integration with Jupyter Notebooks and data visualization through integration with Amazon QuickSight.
 * </p>
 * <p>
 * Traditional analytics and business intelligence tools are designed to process structured data. IoT data often comes
 * from devices that record noisy processes (such as temperature, motion, or sound). As a result the data from these
 * devices can have significant gaps, corrupted messages, and false readings that must be cleaned up before analysis can
 * occur. Also, IoT data is often only meaningful in the context of other data from external sources.
 * </p>
 * <p>
 * IoT Analytics automates the steps required to analyze data from IoT devices. IoT Analytics filters, transforms, and
 * enriches IoT data before storing it in a time-series data store for analysis. You can set up the service to collect
 * only the data you need from your devices, apply mathematical transforms to process the data, and enrich the data with
 * device-specific metadata such as device type and location before storing it. Then, you can analyze your data by
 * running queries using the built-in SQL query engine, or perform more complex analytics and machine learning
 * inference. IoT Analytics includes pre-built models for common IoT use cases so you can answer questions like which
 * devices are about to fail or which customers are at risk of abandoning their wearable devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTAnalyticsAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotanalytics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotanalytics";

    /**
     * <p>
     * Sends messages to a channel.
     * </p>
     *
     * @param batchPutMessageRequest
     * @return A Java Future containing the result of the BatchPutMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/BatchPutMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchPutMessageResponse> batchPutMessage(BatchPutMessageRequest batchPutMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends messages to a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMessageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMessageRequest#builder()}
     * </p>
     *
     * @param batchPutMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchPutMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/BatchPutMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchPutMessageResponse> batchPutMessage(
            Consumer<BatchPutMessageRequest.Builder> batchPutMessageRequest) {
        return batchPutMessage(BatchPutMessageRequest.builder().applyMutation(batchPutMessageRequest).build());
    }

    /**
     * <p>
     * Cancels the reprocessing of data through the pipeline.
     * </p>
     *
     * @param cancelPipelineReprocessingRequest
     * @return A Java Future containing the result of the CancelPipelineReprocessing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CancelPipelineReprocessing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CancelPipelineReprocessing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPipelineReprocessingResponse> cancelPipelineReprocessing(
            CancelPipelineReprocessingRequest cancelPipelineReprocessingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the reprocessing of data through the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelPipelineReprocessingRequest.Builder} avoiding
     * the need to create one manually via {@link CancelPipelineReprocessingRequest#builder()}
     * </p>
     *
     * @param cancelPipelineReprocessingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelPipelineReprocessing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CancelPipelineReprocessing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CancelPipelineReprocessing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPipelineReprocessingResponse> cancelPipelineReprocessing(
            Consumer<CancelPipelineReprocessingRequest.Builder> cancelPipelineReprocessingRequest) {
        return cancelPipelineReprocessing(CancelPipelineReprocessingRequest.builder()
                .applyMutation(cancelPipelineReprocessingRequest).build());
    }

    /**
     * <p>
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages
     * before publishing the data to a pipeline.
     * </p>
     *
     * @param createChannelRequest
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages
     * before publishing the data to a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a
     * <code>queryAction</code> (a SQL query) or a <code>containerAction</code> (executing a containerized application).
     * This operation creates the skeleton of a dataset. The dataset can be populated manually by calling
     * <code>CreateDatasetContent</code> or automatically according to a trigger you specify.
     * </p>
     *
     * @param createDatasetRequest
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a
     * <code>queryAction</code> (a SQL query) or a <code>containerAction</code> (executing a containerized application).
     * This operation creates the skeleton of a dataset. The dataset can be populated manually by calling
     * <code>CreateDatasetContent</code> or automatically according to a trigger you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatasetResponse> createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest) {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates the content of a dataset by applying a <code>queryAction</code> (a SQL query) or a
     * <code>containerAction</code> (executing a containerized application).
     * </p>
     *
     * @param createDatasetContentRequest
     * @return A Java Future containing the result of the CreateDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatasetContentResponse> createDatasetContent(
            CreateDatasetContentRequest createDatasetContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the content of a dataset by applying a <code>queryAction</code> (a SQL query) or a
     * <code>containerAction</code> (executing a containerized application).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetContentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetContentRequest#builder()}
     * </p>
     *
     * @param createDatasetContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatasetContentResponse> createDatasetContent(
            Consumer<CreateDatasetContentRequest.Builder> createDatasetContentRequest) {
        return createDatasetContent(CreateDatasetContentRequest.builder().applyMutation(createDatasetContentRequest).build());
    }

    /**
     * <p>
     * Creates a data store, which is a repository for messages.
     * </p>
     *
     * @param createDatastoreRequest
     * @return A Java Future containing the result of the CreateDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatastoreResponse> createDatastore(CreateDatastoreRequest createDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data store, which is a repository for messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatastoreRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDatastoreRequest#builder()}
     * </p>
     *
     * @param createDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreateDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatastoreResponse> createDatastore(
            Consumer<CreateDatastoreRequest.Builder> createDatastoreRequest) {
        return createDatastore(CreateDatastoreRequest.builder().applyMutation(createDatastoreRequest).build());
    }

    /**
     * <p>
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before
     * storing them in a data store. You must specify both a <code>channel</code> and a <code>datastore</code> activity
     * and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.
     * </p>
     *
     * @param createPipelineRequest
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before
     * storing them in a data store. You must specify both a <code>channel</code> and a <code>datastore</code> activity
     * and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Deletes the specified channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified dataset.
     * </p>
     * <p>
     * You do not have to delete the content of the dataset before you perform this operation.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified dataset.
     * </p>
     * <p>
     * You do not have to delete the content of the dataset before you perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the content of the specified dataset.
     * </p>
     *
     * @param deleteDatasetContentRequest
     * @return A Java Future containing the result of the DeleteDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetContentResponse> deleteDatasetContent(
            DeleteDatasetContentRequest deleteDatasetContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content of the specified dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetContentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDatasetContentRequest#builder()}
     * </p>
     *
     * @param deleteDatasetContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetContentResponse> deleteDatasetContent(
            Consumer<DeleteDatasetContentRequest.Builder> deleteDatasetContentRequest) {
        return deleteDatasetContent(DeleteDatasetContentRequest.builder().applyMutation(deleteDatasetContentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified data store.
     * </p>
     *
     * @param deleteDatastoreRequest
     * @return A Java Future containing the result of the DeleteDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatastoreResponse> deleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatastoreRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDatastoreRequest#builder()}
     * </p>
     *
     * @param deleteDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeleteDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatastoreResponse> deleteDatastore(
            Consumer<DeleteDatastoreRequest.Builder> deleteDatastoreRequest) {
        return deleteDatastore(DeleteDatastoreRequest.builder().applyMutation(deleteDatastoreRequest).build());
    }

    /**
     * <p>
     * Deletes the specified pipeline.
     * </p>
     *
     * @param deletePipelineRequest
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a channel.
     * </p>
     *
     * @param describeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(DescribeChannelRequest describeChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(
            Consumer<DescribeChannelRequest.Builder> describeChannelRequest) {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a dataset.
     * </p>
     *
     * @param describeDatasetRequest
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(
            Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest) {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a data store.
     * </p>
     *
     * @param describeDatastoreRequest
     * @return A Java Future containing the result of the DescribeDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDatastoreResponse> describeDatastore(DescribeDatastoreRequest describeDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatastoreRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatastoreRequest#builder()}
     * </p>
     *
     * @param describeDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDatastoreResponse> describeDatastore(
            Consumer<DescribeDatastoreRequest.Builder> describeDatastoreRequest) {
        return describeDatastore(DescribeDatastoreRequest.builder().applyMutation(describeDatastoreRequest).build());
    }

    /**
     * <p>
     * Retrieves the current settings of the IoT Analytics logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current settings of the IoT Analytics logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePipelineResponse> describePipeline(DescribePipelineRequest describePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePipelineRequest#builder()}
     * </p>
     *
     * @param describePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePipelineResponse> describePipeline(
            Consumer<DescribePipelineRequest.Builder> describePipelineRequest) {
        return describePipeline(DescribePipelineRequest.builder().applyMutation(describePipelineRequest).build());
    }

    /**
     * <p>
     * Retrieves the contents of a dataset as presigned URIs.
     * </p>
     *
     * @param getDatasetContentRequest
     * @return A Java Future containing the result of the GetDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.GetDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/GetDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatasetContentResponse> getDatasetContent(GetDatasetContentRequest getDatasetContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contents of a dataset as presigned URIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatasetContentRequest.Builder} avoiding the need
     * to create one manually via {@link GetDatasetContentRequest#builder()}
     * </p>
     *
     * @param getDatasetContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDatasetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.GetDatasetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/GetDatasetContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatasetContentResponse> getDatasetContent(
            Consumer<GetDatasetContentRequest.Builder> getDatasetContentRequest) {
        return getDatasetContent(GetDatasetContentRequest.builder().applyMutation(getDatasetContentRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of channels.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of channels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of channels.
     * </p>
     *
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels() {
        return listChannels(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator() {
        return listChannelsPaginator(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Lists information about dataset contents that have been created.
     * </p>
     *
     * @param listDatasetContentsRequest
     * @return A Java Future containing the result of the ListDatasetContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasetContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDatasetContentsResponse> listDatasetContents(
            ListDatasetContentsRequest listDatasetContentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about dataset contents that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetContentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetContentsRequest#builder()}
     * </p>
     *
     * @param listDatasetContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDatasetContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasetContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDatasetContentsResponse> listDatasetContents(
            Consumer<ListDatasetContentsRequest.Builder> listDatasetContentsRequest) {
        return listDatasetContents(ListDatasetContentsRequest.builder().applyMutation(listDatasetContentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatasetContents(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsPublisher publisher = client.listDatasetContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsPublisher publisher = client.listDatasetContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetContents(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetContentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasetContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetContentsPublisher listDatasetContentsPaginator(ListDatasetContentsRequest listDatasetContentsRequest) {
        return new ListDatasetContentsPublisher(this, listDatasetContentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatasetContents(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsPublisher publisher = client.listDatasetContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsPublisher publisher = client.listDatasetContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetContents(software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetContentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetContentsRequest#builder()}
     * </p>
     *
     * @param listDatasetContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasetContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetContentsPublisher listDatasetContentsPaginator(
            Consumer<ListDatasetContentsRequest.Builder> listDatasetContentsRequest) {
        return listDatasetContentsPaginator(ListDatasetContentsRequest.builder().applyMutation(listDatasetContentsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about datasets.
     * </p>
     *
     * @param listDatasetsRequest
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about datasets.
     * </p>
     *
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets() {
        return listDatasets(ListDatasetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsPublisher listDatasetsPaginator() {
        return listDatasetsPaginator(ListDatasetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsPublisher listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) {
        return new ListDatasetsPublisher(this, listDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsPublisher listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of data stores.
     * </p>
     *
     * @param listDatastoresRequest
     * @return A Java Future containing the result of the ListDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatastoresResponse> listDatastores(ListDatastoresRequest listDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of data stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatastoresRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatastoresRequest#builder()}
     * </p>
     *
     * @param listDatastoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatastoresResponse> listDatastores(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) {
        return listDatastores(ListDatastoresRequest.builder().applyMutation(listDatastoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of data stores.
     * </p>
     *
     * @return A Java Future containing the result of the ListDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatastoresResponse> listDatastores() {
        return listDatastores(ListDatastoresRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatastoresPublisher listDatastoresPaginator() {
        return listDatastoresPaginator(ListDatastoresRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation.</b>
     * </p>
     *
     * @param listDatastoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatastoresPublisher listDatastoresPaginator(ListDatastoresRequest listDatastoresRequest) {
        return new ListDatastoresPublisher(this, listDatastoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresPublisher publisher = client.listDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatastores(software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatastoresRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatastoresRequest#builder()}
     * </p>
     *
     * @param listDatastoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatastoresPublisher listDatastoresPaginator(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) {
        return listDatastoresPaginator(ListDatastoresRequest.builder().applyMutation(listDatastoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of pipelines.
     * </p>
     *
     * @param listPipelinesRequest
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelines(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of pipelines.
     * </p>
     *
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines() {
        return listPipelines(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator() {
        return listPipelinesPaginator(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) {
        return new ListPipelinesPublisher(this, listPipelinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelinesPaginator(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) that you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) that you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets or updates the IoT Analytics logging options.
     * </p>
     * <p>
     * If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>roleArn</code> field
     * (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or updates the IoT Analytics logging options.
     * </p>
     * <p>
     * If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>roleArn</code> field
     * (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(
            Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest) {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Simulates the results of running a pipeline activity on a message payload.
     * </p>
     *
     * @param runPipelineActivityRequest
     * @return A Java Future containing the result of the RunPipelineActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.RunPipelineActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/RunPipelineActivity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RunPipelineActivityResponse> runPipelineActivity(
            RunPipelineActivityRequest runPipelineActivityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates the results of running a pipeline activity on a message payload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunPipelineActivityRequest.Builder} avoiding the
     * need to create one manually via {@link RunPipelineActivityRequest#builder()}
     * </p>
     *
     * @param runPipelineActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RunPipelineActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.RunPipelineActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/RunPipelineActivity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RunPipelineActivityResponse> runPipelineActivity(
            Consumer<RunPipelineActivityRequest.Builder> runPipelineActivityRequest) {
        return runPipelineActivity(RunPipelineActivityRequest.builder().applyMutation(runPipelineActivityRequest).build());
    }

    /**
     * <p>
     * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10
     * messages can be retrieved.
     * </p>
     *
     * @param sampleChannelDataRequest
     * @return A Java Future containing the result of the SampleChannelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.SampleChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/SampleChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SampleChannelDataResponse> sampleChannelData(SampleChannelDataRequest sampleChannelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10
     * messages can be retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SampleChannelDataRequest.Builder} avoiding the need
     * to create one manually via {@link SampleChannelDataRequest#builder()}
     * </p>
     *
     * @param sampleChannelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SampleChannelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.SampleChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/SampleChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SampleChannelDataResponse> sampleChannelData(
            Consumer<SampleChannelDataRequest.Builder> sampleChannelDataRequest) {
        return sampleChannelData(SampleChannelDataRequest.builder().applyMutation(sampleChannelDataRequest).build());
    }

    /**
     * <p>
     * Starts the reprocessing of raw message data through the pipeline.
     * </p>
     *
     * @param startPipelineReprocessingRequest
     * @return A Java Future containing the result of the StartPipelineReprocessing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.StartPipelineReprocessing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/StartPipelineReprocessing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPipelineReprocessingResponse> startPipelineReprocessing(
            StartPipelineReprocessingRequest startPipelineReprocessingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the reprocessing of raw message data through the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPipelineReprocessingRequest.Builder} avoiding
     * the need to create one manually via {@link StartPipelineReprocessingRequest#builder()}
     * </p>
     *
     * @param startPipelineReprocessingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartPipelineReprocessing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>ResourceAlreadyExistsException A resource with the same name already exists.</li>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.StartPipelineReprocessing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/StartPipelineReprocessing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPipelineReprocessingResponse> startPipelineReprocessing(
            Consumer<StartPipelineReprocessingRequest.Builder> startPipelineReprocessingRequest) {
        return startPipelineReprocessing(StartPipelineReprocessingRequest.builder()
                .applyMutation(startPipelineReprocessingRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Used to update the settings of a channel.
     * </p>
     *
     * @param updateChannelRequest
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to update the settings of a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Updates the settings of a dataset.
     * </p>
     *
     * @param updateDatasetRequest
     * @return A Java Future containing the result of the UpdateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatasetResponse> updateDataset(UpdateDatasetRequest updateDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatasetRequest#builder()}
     * </p>
     *
     * @param updateDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatasetResponse> updateDataset(Consumer<UpdateDatasetRequest.Builder> updateDatasetRequest) {
        return updateDataset(UpdateDatasetRequest.builder().applyMutation(updateDatasetRequest).build());
    }

    /**
     * <p>
     * Used to update the settings of a data store.
     * </p>
     *
     * @param updateDatastoreRequest
     * @return A Java Future containing the result of the UpdateDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatastoreResponse> updateDatastore(UpdateDatastoreRequest updateDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to update the settings of a data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatastoreRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDatastoreRequest#builder()}
     * </p>
     *
     * @param updateDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdateDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDatastore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatastoreResponse> updateDatastore(
            Consumer<UpdateDatastoreRequest.Builder> updateDatastoreRequest) {
        return updateDatastore(UpdateDatastoreRequest.builder().applyMutation(updateDatastoreRequest).build());
    }

    /**
     * <p>
     * Updates the settings of a pipeline. You must specify both a <code>channel</code> and a <code>datastore</code>
     * activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.
     * </p>
     *
     * @param updatePipelineRequest
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of a pipeline. You must specify both a <code>channel</code> and a <code>datastore</code>
     * activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePipelineRequest#builder()}
     * </p>
     *
     * @param updatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was not valid.</li>
     *         <li>ResourceNotFoundException A resource with the specified name could not be found.</li>
     *         <li>InternalFailureException There was an internal failure.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The command caused an internal limit to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTAnalyticsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTAnalyticsAsyncClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest) {
        return updatePipeline(UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest).build());
    }

    @Override
    default IoTAnalyticsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTAnalyticsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTAnalyticsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTAnalyticsAsyncClient}.
     */
    static IoTAnalyticsAsyncClientBuilder builder() {
        return new DefaultIoTAnalyticsAsyncClientBuilder();
    }
}
