/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, CreateChannelResponse> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(CreateChannelResponse.getter(CreateChannelResponse::channelName)).setter(CreateChannelResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(CreateChannelResponse.getter(CreateChannelResponse::channelArn)).setter(CreateChannelResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionPeriod").getter(CreateChannelResponse.getter(CreateChannelResponse::retentionPeriod)).setter(CreateChannelResponse.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, CHANNEL_ARN_FIELD, RETENTION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("channelName", CHANNEL_NAME_FIELD);
            this.put("channelArn", CHANNEL_ARN_FIELD);
            this.put("retentionPeriod", RETENTION_PERIOD_FIELD);
        }
    });
    private final String channelName;
    private final String channelArn;
    private final RetentionPeriod retentionPeriod;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelArn = builder.channelArn;
        this.retentionPeriod = builder.retentionPeriod;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelResponse").add("ChannelName", (Object)this.channelName()).add("ChannelArn", (Object)this.channelArn()).add("RetentionPeriod", (Object)this.retentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private String channelName;
        private String channelArn;
        private RetentionPeriod retentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            this.channelName(model.channelName);
            this.channelArn(model.channelArn);
            this.retentionPeriod(model.retentionPeriod);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelResponse> {
        public Builder channelName(String var1);

        public Builder channelArn(String var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }
    }
}

