/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more sets of channel messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelMessages implements SdkPojo, Serializable, ToCopyableBuilder<ChannelMessages.Builder, ChannelMessages> {
    private static final SdkField<List<String>> S3_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("s3Paths")
            .getter(getter(ChannelMessages::s3Paths))
            .setter(setter(Builder::s3Paths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Paths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_PATHS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> s3Paths;

    private ChannelMessages(BuilderImpl builder) {
        this.s3Paths = builder.s3Paths;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Paths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasS3Paths() {
        return s3Paths != null && !(s3Paths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your
     * channel messages.
     * </p>
     * <p>
     * You must use the full path for the key.
     * </p>
     * <p>
     * Example path:
     * <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Paths} method.
     * </p>
     * 
     * @return Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save
     *         your channel messages.</p>
     *         <p>
     *         You must use the full path for the key.
     *         </p>
     *         <p>
     *         Example path:
     *         <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
     */
    public final List<String> s3Paths() {
        return s3Paths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Paths() ? s3Paths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessages)) {
            return false;
        }
        ChannelMessages other = (ChannelMessages) obj;
        return hasS3Paths() == other.hasS3Paths() && Objects.equals(s3Paths(), other.s3Paths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelMessages").add("S3Paths", hasS3Paths() ? s3Paths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Paths":
            return Optional.ofNullable(clazz.cast(s3Paths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Paths", S3_PATHS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessages, T> g) {
        return obj -> g.apply((ChannelMessages) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelMessages> {
        /**
         * <p>
         * Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your
         * channel messages.
         * </p>
         * <p>
         * You must use the full path for the key.
         * </p>
         * <p>
         * Example path:
         * <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
         * </p>
         * 
         * @param s3Paths
         *        Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that
         *        save your channel messages.</p>
         *        <p>
         *        You must use the full path for the key.
         *        </p>
         *        <p>
         *        Example path:
         *        <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Paths(Collection<String> s3Paths);

        /**
         * <p>
         * Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your
         * channel messages.
         * </p>
         * <p>
         * You must use the full path for the key.
         * </p>
         * <p>
         * Example path:
         * <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
         * </p>
         * 
         * @param s3Paths
         *        Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that
         *        save your channel messages.</p>
         *        <p>
         *        You must use the full path for the key.
         *        </p>
         *        <p>
         *        Example path:
         *        <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Paths(String... s3Paths);
    }

    static final class BuilderImpl implements Builder {
        private List<String> s3Paths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessages model) {
            s3Paths(model.s3Paths);
        }

        public final Collection<String> getS3Paths() {
            if (s3Paths instanceof SdkAutoConstructList) {
                return null;
            }
            return s3Paths;
        }

        public final void setS3Paths(Collection<String> s3Paths) {
            this.s3Paths = S3PathChannelMessagesCopier.copy(s3Paths);
        }

        @Override
        public final Builder s3Paths(Collection<String> s3Paths) {
            this.s3Paths = S3PathChannelMessagesCopier.copy(s3Paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Paths(String... s3Paths) {
            s3Paths(Arrays.asList(s3Paths));
            return this;
        }

        @Override
        public ChannelMessages build() {
            return new ChannelMessages(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
