/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the partition dimensions in a data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastorePartitions implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastorePartitions.Builder, DatastorePartitions> {
    private static final SdkField<List<DatastorePartition>> PARTITIONS_FIELD = SdkField
            .<List<DatastorePartition>> builder(MarshallingType.LIST)
            .memberName("partitions")
            .getter(getter(DatastorePartitions::partitions))
            .setter(setter(Builder::partitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatastorePartition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatastorePartition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DatastorePartition> partitions;

    private DatastorePartitions(BuilderImpl builder) {
        this.partitions = builder.partitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Partitions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPartitions() {
        return partitions != null && !(partitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of partition dimensions in a data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitions} method.
     * </p>
     * 
     * @return A list of partition dimensions in a data store.
     */
    public final List<DatastorePartition> partitions() {
        return partitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitions() ? partitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastorePartitions)) {
            return false;
        }
        DatastorePartitions other = (DatastorePartitions) obj;
        return hasPartitions() == other.hasPartitions() && Objects.equals(partitions(), other.partitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastorePartitions").add("Partitions", hasPartitions() ? partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "partitions":
            return Optional.ofNullable(clazz.cast(partitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("partitions", PARTITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastorePartitions, T> g) {
        return obj -> g.apply((DatastorePartitions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastorePartitions> {
        /**
         * <p>
         * A list of partition dimensions in a data store.
         * </p>
         * 
         * @param partitions
         *        A list of partition dimensions in a data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Collection<DatastorePartition> partitions);

        /**
         * <p>
         * A list of partition dimensions in a data store.
         * </p>
         * 
         * @param partitions
         *        A list of partition dimensions in a data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(DatastorePartition... partitions);

        /**
         * <p>
         * A list of partition dimensions in a data store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.DatastorePartition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotanalytics.model.DatastorePartition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.DatastorePartition.Builder#build()} is called
         * immediately and its result is passed to {@link #partitions(List<DatastorePartition>)}.
         * 
         * @param partitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.DatastorePartition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitions(java.util.Collection<DatastorePartition>)
         */
        Builder partitions(Consumer<DatastorePartition.Builder>... partitions);
    }

    static final class BuilderImpl implements Builder {
        private List<DatastorePartition> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatastorePartitions model) {
            partitions(model.partitions);
        }

        public final List<DatastorePartition.Builder> getPartitions() {
            List<DatastorePartition.Builder> result = PartitionsCopier.copyToBuilder(this.partitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitions(Collection<DatastorePartition.BuilderImpl> partitions) {
            this.partitions = PartitionsCopier.copyFromBuilder(partitions);
        }

        @Override
        public final Builder partitions(Collection<DatastorePartition> partitions) {
            this.partitions = PartitionsCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(DatastorePartition... partitions) {
            partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<DatastorePartition.Builder>... partitions) {
            partitions(Stream.of(partitions).map(c -> DatastorePartition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DatastorePartitions build() {
            return new DatastorePartitions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
