/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that computes an arithmetic expression using the message's attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MathActivity implements SdkPojo, Serializable, ToCopyableBuilder<MathActivity.Builder, MathActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MathActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(MathActivity::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> MATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("math")
            .getter(getter(MathActivity::math)).setter(setter(Builder::math))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("math").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("next")
            .getter(getter(MathActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_FIELD,
            MATH_FIELD, NEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String attribute;

    private final String math;

    private final String next;

    private MathActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.attribute = builder.attribute;
        this.math = builder.math;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the math activity.
     * </p>
     * 
     * @return The name of the math activity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the attribute that contains the result of the math operation.
     * </p>
     * 
     * @return The name of the attribute that contains the result of the math operation.
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * <p>
     * An expression that uses one or more existing attributes and must return an integer value.
     * </p>
     * 
     * @return An expression that uses one or more existing attributes and must return an integer value.
     */
    public final String math() {
        return math;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public final String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(math());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MathActivity)) {
            return false;
        }
        MathActivity other = (MathActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(math(), other.math()) && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MathActivity").add("Name", name()).add("Attribute", attribute()).add("Math", math())
                .add("Next", next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "math":
            return Optional.ofNullable(clazz.cast(math()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("math", MATH_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MathActivity, T> g) {
        return obj -> g.apply((MathActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MathActivity> {
        /**
         * <p>
         * The name of the math activity.
         * </p>
         * 
         * @param name
         *        The name of the math activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute that contains the result of the math operation.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute that contains the result of the math operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * An expression that uses one or more existing attributes and must return an integer value.
         * </p>
         * 
         * @param math
         *        An expression that uses one or more existing attributes and must return an integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder math(String math);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String attribute;

        private String math;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(MathActivity model) {
            name(model.name);
            attribute(model.attribute);
            math(model.math);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getMath() {
            return math;
        }

        public final void setMath(String math) {
            this.math = math;
        }

        @Override
        public final Builder math(String math) {
            this.math = math;
            return this;
        }

        public final String getNext() {
            return next;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        @Override
        public MathActivity build() {
            return new MathActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
