/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>DatasetTrigger</code> that specifies when the dataset is automatically updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetTrigger implements SdkPojo, Serializable, ToCopyableBuilder<DatasetTrigger.Builder, DatasetTrigger> {
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(DatasetTrigger::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<TriggeringDataset> DATASET_FIELD = SdkField
            .<TriggeringDataset> builder(MarshallingType.SDK_POJO).memberName("dataset").getter(getter(DatasetTrigger::dataset))
            .setter(setter(Builder::dataset)).constructor(TriggeringDataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SCHEDULE_FIELD, DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Schedule schedule;

    private final TriggeringDataset dataset;

    private DatasetTrigger(BuilderImpl builder) {
        this.schedule = builder.schedule;
        this.dataset = builder.dataset;
    }

    /**
     * <p>
     * The Schedule when the trigger is initiated.
     * </p>
     * 
     * @return The Schedule when the trigger is initiated.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The dataset whose content creation triggers the creation of this dataset's contents.
     * </p>
     * 
     * @return The dataset whose content creation triggers the creation of this dataset's contents.
     */
    public final TriggeringDataset dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetTrigger)) {
            return false;
        }
        DatasetTrigger other = (DatasetTrigger) obj;
        return Objects.equals(schedule(), other.schedule()) && Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetTrigger").add("Schedule", schedule()).add("Dataset", dataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schedule", SCHEDULE_FIELD);
        map.put("dataset", DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetTrigger, T> g) {
        return obj -> g.apply((DatasetTrigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetTrigger> {
        /**
         * <p>
         * The Schedule when the trigger is initiated.
         * </p>
         * 
         * @param schedule
         *        The Schedule when the trigger is initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The Schedule when the trigger is initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The dataset whose content creation triggers the creation of this dataset's contents.
         * </p>
         * 
         * @param dataset
         *        The dataset whose content creation triggers the creation of this dataset's contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(TriggeringDataset dataset);

        /**
         * <p>
         * The dataset whose content creation triggers the creation of this dataset's contents.
         * </p>
         * This is a convenience method that creates an instance of the {@link TriggeringDataset.Builder} avoiding the
         * need to create one manually via {@link TriggeringDataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TriggeringDataset.Builder#build()} is called immediately and its
         * result is passed to {@link #dataset(TriggeringDataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link TriggeringDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(TriggeringDataset)
         */
        default Builder dataset(Consumer<TriggeringDataset.Builder> dataset) {
            return dataset(TriggeringDataset.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Schedule schedule;

        private TriggeringDataset dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetTrigger model) {
            schedule(model.schedule);
            dataset(model.dataset);
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final TriggeringDataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(TriggeringDataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(TriggeringDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public DatasetTrigger build() {
            return new DatasetTrigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
