/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage,
 * <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is
 * <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreStorage implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreStorage.Builder, DatastoreStorage> {
    private static final SdkField<ServiceManagedDatastoreS3Storage> SERVICE_MANAGED_S3_FIELD = SdkField
            .<ServiceManagedDatastoreS3Storage> builder(MarshallingType.SDK_POJO).memberName("serviceManagedS3")
            .getter(getter(DatastoreStorage::serviceManagedS3)).setter(setter(Builder::serviceManagedS3))
            .constructor(ServiceManagedDatastoreS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()).build();

    private static final SdkField<CustomerManagedDatastoreS3Storage> CUSTOMER_MANAGED_S3_FIELD = SdkField
            .<CustomerManagedDatastoreS3Storage> builder(MarshallingType.SDK_POJO).memberName("customerManagedS3")
            .getter(getter(DatastoreStorage::customerManagedS3)).setter(setter(Builder::customerManagedS3))
            .constructor(CustomerManagedDatastoreS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()).build();

    private static final SdkField<DatastoreIotSiteWiseMultiLayerStorage> IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD = SdkField
            .<DatastoreIotSiteWiseMultiLayerStorage> builder(MarshallingType.SDK_POJO)
            .memberName("iotSiteWiseMultiLayerStorage")
            .getter(getter(DatastoreStorage::iotSiteWiseMultiLayerStorage))
            .setter(setter(Builder::iotSiteWiseMultiLayerStorage))
            .constructor(DatastoreIotSiteWiseMultiLayerStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseMultiLayerStorage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD,
            CUSTOMER_MANAGED_S3_FIELD, IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceManagedDatastoreS3Storage serviceManagedS3;

    private final CustomerManagedDatastoreS3Storage customerManagedS3;

    private final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;

    private final Type type;

    private DatastoreStorage(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
        this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
        this.type = builder.type;
    }

    /**
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
     * storage after your data store is created.
     * </p>
     * 
     * @return Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon
     *         S3 storage after your data store is created.
     */
    public final ServiceManagedDatastoreS3Storage serviceManagedS3() {
        return serviceManagedS3;
    }

    /**
     * <p>
     * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
     * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @return S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter
     *         is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    public final CustomerManagedDatastoreS3Storage customerManagedS3() {
        return customerManagedS3;
    }

    /**
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of
     * Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @return Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
     *         choice of Amazon S3 storage after your data store is created.
     */
    public final DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage() {
        return iotSiteWiseMultiLayerStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseMultiLayerStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorage)) {
            return false;
        }
        DatastoreStorage other = (DatastoreStorage) obj;
        return Objects.equals(serviceManagedS3(), other.serviceManagedS3())
                && Objects.equals(customerManagedS3(), other.customerManagedS3())
                && Objects.equals(iotSiteWiseMultiLayerStorage(), other.iotSiteWiseMultiLayerStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreStorage").add("ServiceManagedS3", serviceManagedS3())
                .add("CustomerManagedS3", customerManagedS3())
                .add("IotSiteWiseMultiLayerStorage", iotSiteWiseMultiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceManagedS3":
            return Optional.ofNullable(clazz.cast(serviceManagedS3()));
        case "customerManagedS3":
            return Optional.ofNullable(clazz.cast(customerManagedS3()));
        case "iotSiteWiseMultiLayerStorage":
            return Optional.ofNullable(clazz.cast(iotSiteWiseMultiLayerStorage()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #serviceManagedS3()} initialized to the given value.
     *
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
     * storage after your data store is created.
     * </p>
     * 
     * @param serviceManagedS3
     *        Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon
     *        S3 storage after your data store is created.
     */
    public static DatastoreStorage fromServiceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
        return builder().serviceManagedS3(serviceManagedS3).build();
    }

    /**
     * Create an instance of this class with {@link #serviceManagedS3()} initialized to the given value.
     *
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
     * storage after your data store is created.
     * </p>
     * 
     * @param serviceManagedS3
     *        Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon
     *        S3 storage after your data store is created.
     */
    public static DatastoreStorage fromServiceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
        ServiceManagedDatastoreS3Storage.Builder builder = ServiceManagedDatastoreS3Storage.builder();
        serviceManagedS3.accept(builder);
        return fromServiceManagedS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #customerManagedS3()} initialized to the given value.
     *
     * <p>
     * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
     * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @param customerManagedS3
     *        S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter
     *        is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    public static DatastoreStorage fromCustomerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
        return builder().customerManagedS3(customerManagedS3).build();
    }

    /**
     * Create an instance of this class with {@link #customerManagedS3()} initialized to the given value.
     *
     * <p>
     * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
     * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @param customerManagedS3
     *        S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter
     *        is ignored. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    public static DatastoreStorage fromCustomerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
        CustomerManagedDatastoreS3Storage.Builder builder = CustomerManagedDatastoreS3Storage.builder();
        customerManagedS3.accept(builder);
        return fromCustomerManagedS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iotSiteWiseMultiLayerStorage()} initialized to the given value.
     *
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of
     * Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @param iotSiteWiseMultiLayerStorage
     *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
     *        choice of Amazon S3 storage after your data store is created.
     */
    public static DatastoreStorage fromIotSiteWiseMultiLayerStorage(
            DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage) {
        return builder().iotSiteWiseMultiLayerStorage(iotSiteWiseMultiLayerStorage).build();
    }

    /**
     * Create an instance of this class with {@link #iotSiteWiseMultiLayerStorage()} initialized to the given value.
     *
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of
     * Amazon S3 storage after your data store is created.
     * </p>
     * 
     * @param iotSiteWiseMultiLayerStorage
     *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
     *        choice of Amazon S3 storage after your data store is created.
     */
    public static DatastoreStorage fromIotSiteWiseMultiLayerStorage(
            Consumer<DatastoreIotSiteWiseMultiLayerStorage.Builder> iotSiteWiseMultiLayerStorage) {
        DatastoreIotSiteWiseMultiLayerStorage.Builder builder = DatastoreIotSiteWiseMultiLayerStorage.builder();
        iotSiteWiseMultiLayerStorage.accept(builder);
        return fromIotSiteWiseMultiLayerStorage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceManagedS3", SERVICE_MANAGED_S3_FIELD);
        map.put("customerManagedS3", CUSTOMER_MANAGED_S3_FIELD);
        map.put("iotSiteWiseMultiLayerStorage", IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorage, T> g) {
        return obj -> g.apply((DatastoreStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreStorage> {
        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
         * storage after your data store is created.
         * </p>
         * 
         * @param serviceManagedS3
         *        Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of
         *        Amazon S3 storage after your data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3);

        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3
         * storage after your data store is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceManagedDatastoreS3Storage.Builder}
         * avoiding the need to create one manually via {@link ServiceManagedDatastoreS3Storage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedDatastoreS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceManagedS3(ServiceManagedDatastoreS3Storage)}.
         * 
         * @param serviceManagedS3
         *        a consumer that will call methods on {@link ServiceManagedDatastoreS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedS3(ServiceManagedDatastoreS3Storage)
         */
        default Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
            return serviceManagedS3(ServiceManagedDatastoreS3Storage.builder().applyMutation(serviceManagedS3).build());
        }

        /**
         * <p>
         * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
         * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
         * </p>
         * 
         * @param customerManagedS3
         *        S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code>
         *        parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3);

        /**
         * <p>
         * S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is
         * ignored. You can't change the choice of Amazon S3 storage after your data store is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomerManagedDatastoreS3Storage.Builder} avoiding the need to create one manually via
         * {@link CustomerManagedDatastoreS3Storage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedDatastoreS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #customerManagedS3(CustomerManagedDatastoreS3Storage)}.
         * 
         * @param customerManagedS3
         *        a consumer that will call methods on {@link CustomerManagedDatastoreS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3(CustomerManagedDatastoreS3Storage)
         */
        default Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
            return customerManagedS3(CustomerManagedDatastoreS3Storage.builder().applyMutation(customerManagedS3).build());
        }

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice
         * of Amazon S3 storage after your data store is created.
         * </p>
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the
         *        choice of Amazon S3 storage after your data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage);

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice
         * of Amazon S3 storage after your data store is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatastoreIotSiteWiseMultiLayerStorage.Builder} avoiding the need to create one manually via
         * {@link DatastoreIotSiteWiseMultiLayerStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreIotSiteWiseMultiLayerStorage.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage)}.
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        a consumer that will call methods on {@link DatastoreIotSiteWiseMultiLayerStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage)
         */
        default Builder iotSiteWiseMultiLayerStorage(
                Consumer<DatastoreIotSiteWiseMultiLayerStorage.Builder> iotSiteWiseMultiLayerStorage) {
            return iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage.builder()
                    .applyMutation(iotSiteWiseMultiLayerStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedDatastoreS3Storage serviceManagedS3;

        private CustomerManagedDatastoreS3Storage customerManagedS3;

        private DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorage model) {
            serviceManagedS3(model.serviceManagedS3);
            customerManagedS3(model.customerManagedS3);
            iotSiteWiseMultiLayerStorage(model.iotSiteWiseMultiLayerStorage);
        }

        public final ServiceManagedDatastoreS3Storage.Builder getServiceManagedS3() {
            return serviceManagedS3 != null ? serviceManagedS3.toBuilder() : null;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3Storage.BuilderImpl serviceManagedS3) {
            Object oldValue = this.serviceManagedS3;
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
            handleUnionValueChange(Type.SERVICE_MANAGED_S3, oldValue, this.serviceManagedS3);
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
            Object oldValue = this.serviceManagedS3;
            this.serviceManagedS3 = serviceManagedS3;
            handleUnionValueChange(Type.SERVICE_MANAGED_S3, oldValue, this.serviceManagedS3);
            return this;
        }

        public final CustomerManagedDatastoreS3Storage.Builder getCustomerManagedS3() {
            return customerManagedS3 != null ? customerManagedS3.toBuilder() : null;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3Storage.BuilderImpl customerManagedS3) {
            Object oldValue = this.customerManagedS3;
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
            handleUnionValueChange(Type.CUSTOMER_MANAGED_S3, oldValue, this.customerManagedS3);
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
            Object oldValue = this.customerManagedS3;
            this.customerManagedS3 = customerManagedS3;
            handleUnionValueChange(Type.CUSTOMER_MANAGED_S3, oldValue, this.customerManagedS3);
            return this;
        }

        public final DatastoreIotSiteWiseMultiLayerStorage.Builder getIotSiteWiseMultiLayerStorage() {
            return iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.toBuilder() : null;
        }

        public final void setIotSiteWiseMultiLayerStorage(
                DatastoreIotSiteWiseMultiLayerStorage.BuilderImpl iotSiteWiseMultiLayerStorage) {
            Object oldValue = this.iotSiteWiseMultiLayerStorage;
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.build()
                    : null;
            handleUnionValueChange(Type.IOT_SITE_WISE_MULTI_LAYER_STORAGE, oldValue, this.iotSiteWiseMultiLayerStorage);
        }

        @Override
        public final Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorage iotSiteWiseMultiLayerStorage) {
            Object oldValue = this.iotSiteWiseMultiLayerStorage;
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
            handleUnionValueChange(Type.IOT_SITE_WISE_MULTI_LAYER_STORAGE, oldValue, this.iotSiteWiseMultiLayerStorage);
            return this;
        }

        @Override
        public DatastoreStorage build() {
            return new DatastoreStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DatastoreStorage#type()
     */
    public enum Type {
        SERVICE_MANAGED_S3,

        CUSTOMER_MANAGED_S3,

        IOT_SITE_WISE_MULTI_LAYER_STORAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
