/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the name and configuration information of a late data rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LateDataRule implements SdkPojo, Serializable, ToCopyableBuilder<LateDataRule.Builder, LateDataRule> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(LateDataRule::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<LateDataRuleConfiguration> RULE_CONFIGURATION_FIELD = SdkField
            .<LateDataRuleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ruleConfiguration")
            .getter(getter(LateDataRule::ruleConfiguration)).setter(setter(Builder::ruleConfiguration))
            .constructor(LateDataRuleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final LateDataRuleConfiguration ruleConfiguration;

    private LateDataRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleConfiguration = builder.ruleConfiguration;
    }

    /**
     * <p>
     * The name of the late data rule.
     * </p>
     * 
     * @return The name of the late data rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The information needed to configure the late data rule.
     * </p>
     * 
     * @return The information needed to configure the late data rule.
     */
    public final LateDataRuleConfiguration ruleConfiguration() {
        return ruleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LateDataRule)) {
            return false;
        }
        LateDataRule other = (LateDataRule) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleConfiguration(), other.ruleConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LateDataRule").add("RuleName", ruleName()).add("RuleConfiguration", ruleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "ruleConfiguration":
            return Optional.ofNullable(clazz.cast(ruleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("ruleConfiguration", RULE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LateDataRule, T> g) {
        return obj -> g.apply((LateDataRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LateDataRule> {
        /**
         * <p>
         * The name of the late data rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the late data rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The information needed to configure the late data rule.
         * </p>
         * 
         * @param ruleConfiguration
         *        The information needed to configure the late data rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfiguration(LateDataRuleConfiguration ruleConfiguration);

        /**
         * <p>
         * The information needed to configure the late data rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link LateDataRuleConfiguration.Builder}
         * avoiding the need to create one manually via {@link LateDataRuleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LateDataRuleConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleConfiguration(LateDataRuleConfiguration)}.
         * 
         * @param ruleConfiguration
         *        a consumer that will call methods on {@link LateDataRuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConfiguration(LateDataRuleConfiguration)
         */
        default Builder ruleConfiguration(Consumer<LateDataRuleConfiguration.Builder> ruleConfiguration) {
            return ruleConfiguration(LateDataRuleConfiguration.builder().applyMutation(ruleConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private LateDataRuleConfiguration ruleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LateDataRule model) {
            ruleName(model.ruleName);
            ruleConfiguration(model.ruleConfiguration);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final LateDataRuleConfiguration.Builder getRuleConfiguration() {
            return ruleConfiguration != null ? ruleConfiguration.toBuilder() : null;
        }

        public final void setRuleConfiguration(LateDataRuleConfiguration.BuilderImpl ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration != null ? ruleConfiguration.build() : null;
        }

        @Override
        public final Builder ruleConfiguration(LateDataRuleConfiguration ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration;
            return this;
        }

        @Override
        public LateDataRule build() {
            return new LateDataRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
