/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference to a dataset entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetEntry implements SdkPojo, Serializable, ToCopyableBuilder<DatasetEntry.Builder, DatasetEntry> {
    private static final SdkField<String> ENTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryName").getter(getter(DatasetEntry::entryName)).setter(setter(Builder::entryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryName").build()).build();

    private static final SdkField<String> DATA_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataURI").getter(getter(DatasetEntry::dataURI)).setter(setter(Builder::dataURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_NAME_FIELD,
            DATA_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryName;

    private final String dataURI;

    private DatasetEntry(BuilderImpl builder) {
        this.entryName = builder.entryName;
        this.dataURI = builder.dataURI;
    }

    /**
     * <p>
     * The name of the dataset item.
     * </p>
     * 
     * @return The name of the dataset item.
     */
    public final String entryName() {
        return entryName;
    }

    /**
     * <p>
     * The presigned URI of the dataset item.
     * </p>
     * 
     * @return The presigned URI of the dataset item.
     */
    public final String dataURI() {
        return dataURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryName());
        hashCode = 31 * hashCode + Objects.hashCode(dataURI());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetEntry)) {
            return false;
        }
        DatasetEntry other = (DatasetEntry) obj;
        return Objects.equals(entryName(), other.entryName()) && Objects.equals(dataURI(), other.dataURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetEntry").add("EntryName", entryName()).add("DataURI", dataURI()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryName":
            return Optional.ofNullable(clazz.cast(entryName()));
        case "dataURI":
            return Optional.ofNullable(clazz.cast(dataURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryName", ENTRY_NAME_FIELD);
        map.put("dataURI", DATA_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetEntry, T> g) {
        return obj -> g.apply((DatasetEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetEntry> {
        /**
         * <p>
         * The name of the dataset item.
         * </p>
         * 
         * @param entryName
         *        The name of the dataset item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryName(String entryName);

        /**
         * <p>
         * The presigned URI of the dataset item.
         * </p>
         * 
         * @param dataURI
         *        The presigned URI of the dataset item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataURI(String dataURI);
    }

    static final class BuilderImpl implements Builder {
        private String entryName;

        private String dataURI;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetEntry model) {
            entryName(model.entryName);
            dataURI(model.dataURI);
        }

        public final String getEntryName() {
            return entryName;
        }

        public final void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        @Override
        public final Builder entryName(String entryName) {
            this.entryName = entryName;
            return this;
        }

        public final String getDataURI() {
            return dataURI;
        }

        public final void setDataURI(String dataURI) {
            this.dataURI = dataURI;
        }

        @Override
        public final Builder dataURI(String dataURI) {
            this.dataURI = dataURI;
            return this;
        }

        @Override
        public DatasetEntry build() {
            return new DatasetEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
