/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoggingOptionsResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<DescribeLoggingOptionsResponse.Builder, DescribeLoggingOptionsResponse> {
    private static final SdkField<LoggingOptions> LOGGING_OPTIONS_FIELD = SdkField
            .<LoggingOptions> builder(MarshallingType.SDK_POJO).memberName("loggingOptions")
            .getter(getter(DescribeLoggingOptionsResponse::loggingOptions)).setter(setter(Builder::loggingOptions))
            .constructor(LoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LoggingOptions loggingOptions;

    private DescribeLoggingOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingOptions = builder.loggingOptions;
    }

    /**
     * <p>
     * The current settings of the IoT Analytics logging options.
     * </p>
     * 
     * @return The current settings of the IoT Analytics logging options.
     */
    public final LoggingOptions loggingOptions() {
        return loggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoggingOptionsResponse)) {
            return false;
        }
        DescribeLoggingOptionsResponse other = (DescribeLoggingOptionsResponse) obj;
        return Objects.equals(loggingOptions(), other.loggingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoggingOptionsResponse").add("LoggingOptions", loggingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingOptions":
            return Optional.ofNullable(clazz.cast(loggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("loggingOptions", LOGGING_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoggingOptionsResponse, T> g) {
        return obj -> g.apply((DescribeLoggingOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoggingOptionsResponse> {
        /**
         * <p>
         * The current settings of the IoT Analytics logging options.
         * </p>
         * 
         * @param loggingOptions
         *        The current settings of the IoT Analytics logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingOptions(LoggingOptions loggingOptions);

        /**
         * <p>
         * The current settings of the IoT Analytics logging options.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingOptions.Builder} avoiding the need
         * to create one manually via {@link LoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingOptions(LoggingOptions)}.
         * 
         * @param loggingOptions
         *        a consumer that will call methods on {@link LoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingOptions(LoggingOptions)
         */
        default Builder loggingOptions(Consumer<LoggingOptions.Builder> loggingOptions) {
            return loggingOptions(LoggingOptions.builder().applyMutation(loggingOptions).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private LoggingOptions loggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoggingOptionsResponse model) {
            super(model);
            loggingOptions(model.loggingOptions);
        }

        public final LoggingOptions.Builder getLoggingOptions() {
            return loggingOptions != null ? loggingOptions.toBuilder() : null;
        }

        public final void setLoggingOptions(LoggingOptions.BuilderImpl loggingOptions) {
            this.loggingOptions = loggingOptions != null ? loggingOptions.build() : null;
        }

        @Override
        public final Builder loggingOptions(LoggingOptions loggingOptions) {
            this.loggingOptions = loggingOptions;
            return this;
        }

        @Override
        public DescribeLoggingOptionsResponse build() {
            return new DescribeLoggingOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
