/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a
 * href="https://parquet.apache.org/">Parquet</a>.
 * </p>
 * <p>
 * The default file format is JSON. You can specify only one format.
 * </p>
 * <p>
 * You can't change the file format after you create the data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FileFormatConfiguration.Builder, FileFormatConfiguration> {
    private static final SdkField<JsonConfiguration> JSON_CONFIGURATION_FIELD = SdkField
            .<JsonConfiguration> builder(MarshallingType.SDK_POJO).memberName("jsonConfiguration")
            .getter(getter(FileFormatConfiguration::jsonConfiguration)).setter(setter(Builder::jsonConfiguration))
            .constructor(JsonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonConfiguration").build()).build();

    private static final SdkField<ParquetConfiguration> PARQUET_CONFIGURATION_FIELD = SdkField
            .<ParquetConfiguration> builder(MarshallingType.SDK_POJO).memberName("parquetConfiguration")
            .getter(getter(FileFormatConfiguration::parquetConfiguration)).setter(setter(Builder::parquetConfiguration))
            .constructor(ParquetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_CONFIGURATION_FIELD,
            PARQUET_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JsonConfiguration jsonConfiguration;

    private final ParquetConfiguration parquetConfiguration;

    private FileFormatConfiguration(BuilderImpl builder) {
        this.jsonConfiguration = builder.jsonConfiguration;
        this.parquetConfiguration = builder.parquetConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of the JSON format.
     * </p>
     * 
     * @return Contains the configuration information of the JSON format.
     */
    public final JsonConfiguration jsonConfiguration() {
        return jsonConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of the Parquet format.
     * </p>
     * 
     * @return Contains the configuration information of the Parquet format.
     */
    public final ParquetConfiguration parquetConfiguration() {
        return parquetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parquetConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileFormatConfiguration)) {
            return false;
        }
        FileFormatConfiguration other = (FileFormatConfiguration) obj;
        return Objects.equals(jsonConfiguration(), other.jsonConfiguration())
                && Objects.equals(parquetConfiguration(), other.parquetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileFormatConfiguration").add("JsonConfiguration", jsonConfiguration())
                .add("ParquetConfiguration", parquetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonConfiguration":
            return Optional.ofNullable(clazz.cast(jsonConfiguration()));
        case "parquetConfiguration":
            return Optional.ofNullable(clazz.cast(parquetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jsonConfiguration", JSON_CONFIGURATION_FIELD);
        map.put("parquetConfiguration", PARQUET_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileFormatConfiguration, T> g) {
        return obj -> g.apply((FileFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileFormatConfiguration> {
        /**
         * <p>
         * Contains the configuration information of the JSON format.
         * </p>
         * 
         * @param jsonConfiguration
         *        Contains the configuration information of the JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonConfiguration(JsonConfiguration jsonConfiguration);

        /**
         * <p>
         * Contains the configuration information of the JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link JsonConfiguration.Builder} avoiding the
         * need to create one manually via {@link JsonConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JsonConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #jsonConfiguration(JsonConfiguration)}.
         * 
         * @param jsonConfiguration
         *        a consumer that will call methods on {@link JsonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonConfiguration(JsonConfiguration)
         */
        default Builder jsonConfiguration(Consumer<JsonConfiguration.Builder> jsonConfiguration) {
            return jsonConfiguration(JsonConfiguration.builder().applyMutation(jsonConfiguration).build());
        }

        /**
         * <p>
         * Contains the configuration information of the Parquet format.
         * </p>
         * 
         * @param parquetConfiguration
         *        Contains the configuration information of the Parquet format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetConfiguration(ParquetConfiguration parquetConfiguration);

        /**
         * <p>
         * Contains the configuration information of the Parquet format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParquetConfiguration.Builder} avoiding
         * the need to create one manually via {@link ParquetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParquetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #parquetConfiguration(ParquetConfiguration)}.
         * 
         * @param parquetConfiguration
         *        a consumer that will call methods on {@link ParquetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquetConfiguration(ParquetConfiguration)
         */
        default Builder parquetConfiguration(Consumer<ParquetConfiguration.Builder> parquetConfiguration) {
            return parquetConfiguration(ParquetConfiguration.builder().applyMutation(parquetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JsonConfiguration jsonConfiguration;

        private ParquetConfiguration parquetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileFormatConfiguration model) {
            jsonConfiguration(model.jsonConfiguration);
            parquetConfiguration(model.parquetConfiguration);
        }

        public final JsonConfiguration.Builder getJsonConfiguration() {
            return jsonConfiguration != null ? jsonConfiguration.toBuilder() : null;
        }

        public final void setJsonConfiguration(JsonConfiguration.BuilderImpl jsonConfiguration) {
            this.jsonConfiguration = jsonConfiguration != null ? jsonConfiguration.build() : null;
        }

        @Override
        public final Builder jsonConfiguration(JsonConfiguration jsonConfiguration) {
            this.jsonConfiguration = jsonConfiguration;
            return this;
        }

        public final ParquetConfiguration.Builder getParquetConfiguration() {
            return parquetConfiguration != null ? parquetConfiguration.toBuilder() : null;
        }

        public final void setParquetConfiguration(ParquetConfiguration.BuilderImpl parquetConfiguration) {
            this.parquetConfiguration = parquetConfiguration != null ? parquetConfiguration.build() : null;
        }

        @Override
        public final Builder parquetConfiguration(ParquetConfiguration parquetConfiguration) {
            this.parquetConfiguration = parquetConfiguration;
            return this;
        }

        @Override
        public FileFormatConfiguration build() {
            return new FileFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
