/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNamedShadowsForThingResponse extends IotDataPlaneResponse implements
        ToCopyableBuilder<ListNamedShadowsForThingResponse.Builder, ListNamedShadowsForThingResponse> {
    private static final SdkField<List<String>> RESULTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListNamedShadowsForThingResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNamedShadowsForThingResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ListNamedShadowsForThingResponse::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            NEXT_TOKEN_FIELD, TIMESTAMP_FIELD));

    private final List<String> results;

    private final String nextToken;

    private final Long timestamp;

    private ListNamedShadowsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
        this.timestamp = builder.timestamp;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of shadows for the specified thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of shadows for the specified thing.
     */
    public List<String> results() {
        return results;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Epoch date and time the response was generated by AWS IoT.
     * </p>
     * 
     * @return The Epoch date and time the response was generated by AWS IoT.
     */
    public Long timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamedShadowsForThingResponse)) {
            return false;
        }
        ListNamedShadowsForThingResponse other = (ListNamedShadowsForThingResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNamedShadowsForThingResponse").add("Results", results()).add("NextToken", nextToken())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamedShadowsForThingResponse, T> g) {
        return obj -> g.apply((ListNamedShadowsForThingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNamedShadowsForThingResponse> {
        /**
         * <p>
         * The list of shadows for the specified thing.
         * </p>
         * 
         * @param results
         *        The list of shadows for the specified thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<String> results);

        /**
         * <p>
         * The list of shadows for the specified thing.
         * </p>
         * 
         * @param results
         *        The list of shadows for the specified thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(String... results);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Epoch date and time the response was generated by AWS IoT.
         * </p>
         * 
         * @param timestamp
         *        The Epoch date and time the response was generated by AWS IoT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);
    }

    static final class BuilderImpl extends IotDataPlaneResponse.BuilderImpl implements Builder {
        private List<String> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamedShadowsForThingResponse model) {
            super(model);
            results(model.results);
            nextToken(model.nextToken);
            timestamp(model.timestamp);
        }

        public final Collection<String> getResults() {
            return results;
        }

        @Override
        public final Builder results(Collection<String> results) {
            this.results = NamedShadowListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(String... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<String> results) {
            this.results = NamedShadowListCopier.copy(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ListNamedShadowsForThingResponse build() {
            return new ListNamedShadowsForThingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
