/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the Publish operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishRequest extends IotDataPlaneRequest implements
        ToCopyableBuilder<PublishRequest.Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(PublishRequest::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("topic").build()).build();

    private static final SdkField<Integer> QOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("qos")
            .getter(getter(PublishRequest::qos)).setter(setter(Builder::qos))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qos").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload")
            .getter(getter(PublishRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, QOS_FIELD,
            PAYLOAD_FIELD));

    private final String topic;

    private final Integer qos;

    private final SdkBytes payload;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The Quality of Service (QoS) level.
     * </p>
     * 
     * @return The Quality of Service (QoS) level.
     */
    public final Integer qos() {
        return qos;
    }

    /**
     * <p>
     * The state information, in JSON format.
     * </p>
     * 
     * @return The state information, in JSON format.
     */
    public final SdkBytes payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(qos(), other.qos())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishRequest").add("Topic", topic()).add("Qos", qos()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "qos":
            return Optional.ofNullable(clazz.cast(qos()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDataPlaneRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishRequest> {
        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Quality of Service (QoS) level.
         * </p>
         * 
         * @param qos
         *        The Quality of Service (QoS) level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * The state information, in JSON format.
         * </p>
         * 
         * @param payload
         *        The state information, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDataPlaneRequest.BuilderImpl implements Builder {
        private String topic;

        private Integer qos;

        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            topic(model.topic);
            qos(model.qos);
            payload(model.payload);
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getQos() {
            return qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
