/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a single retained message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetainedMessageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RetainedMessageSummary.Builder, RetainedMessageSummary> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(RetainedMessageSummary::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<Long> PAYLOAD_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("payloadSize").getter(getter(RetainedMessageSummary::payloadSize)).setter(setter(Builder::payloadSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadSize").build()).build();

    private static final SdkField<Integer> QOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("qos")
            .getter(getter(RetainedMessageSummary::qos)).setter(setter(Builder::qos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(RetainedMessageSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD,
            PAYLOAD_SIZE_FIELD, QOS_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topic;

    private final Long payloadSize;

    private final Integer qos;

    private final Long lastModifiedTime;

    private RetainedMessageSummary(BuilderImpl builder) {
        this.topic = builder.topic;
        this.payloadSize = builder.payloadSize;
        this.qos = builder.qos;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The topic name to which the retained message was published.
     * </p>
     * 
     * @return The topic name to which the retained message was published.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The size of the retained message's payload in bytes.
     * </p>
     * 
     * @return The size of the retained message's payload in bytes.
     */
    public final Long payloadSize() {
        return payloadSize;
    }

    /**
     * <p>
     * The quality of service (QoS) level used to publish the retained message.
     * </p>
     * 
     * @return The quality of service (QoS) level used to publish the retained message.
     */
    public final Integer qos() {
        return qos;
    }

    /**
     * <p>
     * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     * </p>
     * 
     * @return The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(payloadSize());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetainedMessageSummary)) {
            return false;
        }
        RetainedMessageSummary other = (RetainedMessageSummary) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(payloadSize(), other.payloadSize())
                && Objects.equals(qos(), other.qos()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetainedMessageSummary").add("Topic", topic()).add("PayloadSize", payloadSize())
                .add("Qos", qos()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "payloadSize":
            return Optional.ofNullable(clazz.cast(payloadSize()));
        case "qos":
            return Optional.ofNullable(clazz.cast(qos()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetainedMessageSummary, T> g) {
        return obj -> g.apply((RetainedMessageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetainedMessageSummary> {
        /**
         * <p>
         * The topic name to which the retained message was published.
         * </p>
         * 
         * @param topic
         *        The topic name to which the retained message was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The size of the retained message's payload in bytes.
         * </p>
         * 
         * @param payloadSize
         *        The size of the retained message's payload in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadSize(Long payloadSize);

        /**
         * <p>
         * The quality of service (QoS) level used to publish the retained message.
         * </p>
         * 
         * @param qos
         *        The quality of service (QoS) level used to publish the retained message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         * </p>
         * 
         * @param lastModifiedTime
         *        The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String topic;

        private Long payloadSize;

        private Integer qos;

        private Long lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RetainedMessageSummary model) {
            topic(model.topic);
            payloadSize(model.payloadSize);
            qos(model.qos);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        @Transient
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Long getPayloadSize() {
            return payloadSize;
        }

        public final void setPayloadSize(Long payloadSize) {
            this.payloadSize = payloadSize;
        }

        @Override
        @Transient
        public final Builder payloadSize(Long payloadSize) {
            this.payloadSize = payloadSize;
            return this;
        }

        public final Integer getQos() {
            return qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        @Transient
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public RetainedMessageSummary build() {
            return new RetainedMessageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
