/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRetainedMessagesResponse extends IotDataPlaneResponse implements
        ToCopyableBuilder<ListRetainedMessagesResponse.Builder, ListRetainedMessagesResponse> {
    private static final SdkField<List<RetainedMessageSummary>> RETAINED_TOPICS_FIELD = SdkField
            .<List<RetainedMessageSummary>> builder(MarshallingType.LIST)
            .memberName("retainedTopics")
            .getter(getter(ListRetainedMessagesResponse::retainedTopics))
            .setter(setter(Builder::retainedTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainedTopics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetainedMessageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetainedMessageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRetainedMessagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETAINED_TOPICS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("retainedTopics", RETAINED_TOPICS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<RetainedMessageSummary> retainedTopics;

    private final String nextToken;

    private ListRetainedMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.retainedTopics = builder.retainedTopics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetainedTopics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetainedTopics() {
        return retainedTopics != null && !(retainedTopics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetainedTopics} method.
     * </p>
     * 
     * @return A summary list the account's retained messages. The information returned doesn't include the message
     *         payloads of the retained messages.
     */
    public final List<RetainedMessageSummary> retainedTopics() {
        return retainedTopics;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRetainedTopics() ? retainedTopics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetainedMessagesResponse)) {
            return false;
        }
        ListRetainedMessagesResponse other = (ListRetainedMessagesResponse) obj;
        return hasRetainedTopics() == other.hasRetainedTopics() && Objects.equals(retainedTopics(), other.retainedTopics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRetainedMessagesResponse")
                .add("RetainedTopics", hasRetainedTopics() ? retainedTopics() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retainedTopics":
            return Optional.ofNullable(clazz.cast(retainedTopics()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRetainedMessagesResponse, T> g) {
        return obj -> g.apply((ListRetainedMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRetainedMessagesResponse> {
        /**
         * <p>
         * A summary list the account's retained messages. The information returned doesn't include the message payloads
         * of the retained messages.
         * </p>
         * 
         * @param retainedTopics
         *        A summary list the account's retained messages. The information returned doesn't include the message
         *        payloads of the retained messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainedTopics(Collection<RetainedMessageSummary> retainedTopics);

        /**
         * <p>
         * A summary list the account's retained messages. The information returned doesn't include the message payloads
         * of the retained messages.
         * </p>
         * 
         * @param retainedTopics
         *        A summary list the account's retained messages. The information returned doesn't include the message
         *        payloads of the retained messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainedTopics(RetainedMessageSummary... retainedTopics);

        /**
         * <p>
         * A summary list the account's retained messages. The information returned doesn't include the message payloads
         * of the retained messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #retainedTopics(List<RetainedMessageSummary>)}.
         * 
         * @param retainedTopics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainedTopics(java.util.Collection<RetainedMessageSummary>)
         */
        Builder retainedTopics(Consumer<RetainedMessageSummary.Builder>... retainedTopics);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotDataPlaneResponse.BuilderImpl implements Builder {
        private List<RetainedMessageSummary> retainedTopics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetainedMessagesResponse model) {
            super(model);
            retainedTopics(model.retainedTopics);
            nextToken(model.nextToken);
        }

        public final List<RetainedMessageSummary.Builder> getRetainedTopics() {
            List<RetainedMessageSummary.Builder> result = RetainedMessageListCopier.copyToBuilder(this.retainedTopics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetainedTopics(Collection<RetainedMessageSummary.BuilderImpl> retainedTopics) {
            this.retainedTopics = RetainedMessageListCopier.copyFromBuilder(retainedTopics);
        }

        @Override
        public final Builder retainedTopics(Collection<RetainedMessageSummary> retainedTopics) {
            this.retainedTopics = RetainedMessageListCopier.copy(retainedTopics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainedTopics(RetainedMessageSummary... retainedTopics) {
            retainedTopics(Arrays.asList(retainedTopics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainedTopics(Consumer<RetainedMessageSummary.Builder>... retainedTopics) {
            retainedTopics(Stream.of(retainedTopics).map(c -> RetainedMessageSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetainedMessagesResponse build() {
            return new ListRetainedMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
