/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetRetainedMessage operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRetainedMessageResponse extends IotDataPlaneResponse implements
        ToCopyableBuilder<GetRetainedMessageResponse.Builder, GetRetainedMessageResponse> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(GetRetainedMessageResponse::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload").getter(getter(GetRetainedMessageResponse::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<Integer> QOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("qos")
            .getter(getter(GetRetainedMessageResponse::qos)).setter(setter(Builder::qos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(GetRetainedMessageResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<SdkBytes> USER_PROPERTIES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("userProperties").getter(getter(GetRetainedMessageResponse::userProperties))
            .setter(setter(Builder::userProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, PAYLOAD_FIELD,
            QOS_FIELD, LAST_MODIFIED_TIME_FIELD, USER_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String topic;

    private final SdkBytes payload;

    private final Integer qos;

    private final Long lastModifiedTime;

    private final SdkBytes userProperties;

    private GetRetainedMessageResponse(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.payload = builder.payload;
        this.qos = builder.qos;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.userProperties = builder.userProperties;
    }

    /**
     * <p>
     * The topic name to which the retained message was published.
     * </p>
     * 
     * @return The topic name to which the retained message was published.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The Base64-encoded message payload of the retained message body.
     * </p>
     * 
     * @return The Base64-encoded message payload of the retained message body.
     */
    public final SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * The quality of service (QoS) level used to publish the retained message.
     * </p>
     * 
     * @return The quality of service (QoS) level used to publish the retained message.
     */
    public final Integer qos() {
        return qos;
    }

    /**
     * <p>
     * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     * </p>
     * 
     * @return The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A base64-encoded JSON string that includes an array of JSON objects, or null if the retained message doesn't
     * include any user properties.
     * </p>
     * <p>
     * The following example <code>userProperties</code> parameter is a JSON string that represents two user properties.
     * Note that it will be base64-encoded:
     * </p>
     * <p>
     * <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
     * </p>
     * 
     * @return A base64-encoded JSON string that includes an array of JSON objects, or null if the retained message
     *         doesn't include any user properties.</p>
     *         <p>
     *         The following example <code>userProperties</code> parameter is a JSON string that represents two user
     *         properties. Note that it will be base64-encoded:
     *         </p>
     *         <p>
     *         <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
     */
    public final SdkBytes userProperties() {
        return userProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(userProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetainedMessageResponse)) {
            return false;
        }
        GetRetainedMessageResponse other = (GetRetainedMessageResponse) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(payload(), other.payload())
                && Objects.equals(qos(), other.qos()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(userProperties(), other.userProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRetainedMessageResponse").add("Topic", topic()).add("Payload", payload()).add("Qos", qos())
                .add("LastModifiedTime", lastModifiedTime()).add("UserProperties", userProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "qos":
            return Optional.ofNullable(clazz.cast(qos()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "userProperties":
            return Optional.ofNullable(clazz.cast(userProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topic", TOPIC_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("qos", QOS_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("userProperties", USER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRetainedMessageResponse, T> g) {
        return obj -> g.apply((GetRetainedMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDataPlaneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRetainedMessageResponse> {
        /**
         * <p>
         * The topic name to which the retained message was published.
         * </p>
         * 
         * @param topic
         *        The topic name to which the retained message was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Base64-encoded message payload of the retained message body.
         * </p>
         * 
         * @param payload
         *        The Base64-encoded message payload of the retained message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * The quality of service (QoS) level used to publish the retained message.
         * </p>
         * 
         * @param qos
         *        The quality of service (QoS) level used to publish the retained message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         * </p>
         * 
         * @param lastModifiedTime
         *        The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * A base64-encoded JSON string that includes an array of JSON objects, or null if the retained message doesn't
         * include any user properties.
         * </p>
         * <p>
         * The following example <code>userProperties</code> parameter is a JSON string that represents two user
         * properties. Note that it will be base64-encoded:
         * </p>
         * <p>
         * <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
         * </p>
         * 
         * @param userProperties
         *        A base64-encoded JSON string that includes an array of JSON objects, or null if the retained message
         *        doesn't include any user properties.</p>
         *        <p>
         *        The following example <code>userProperties</code> parameter is a JSON string that represents two user
         *        properties. Note that it will be base64-encoded:
         *        </p>
         *        <p>
         *        <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProperties(SdkBytes userProperties);
    }

    static final class BuilderImpl extends IotDataPlaneResponse.BuilderImpl implements Builder {
        private String topic;

        private SdkBytes payload;

        private Integer qos;

        private Long lastModifiedTime;

        private SdkBytes userProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetainedMessageResponse model) {
            super(model);
            topic(model.topic);
            payload(model.payload);
            qos(model.qos);
            lastModifiedTime(model.lastModifiedTime);
            userProperties(model.userProperties);
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final Integer getQos() {
            return qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final ByteBuffer getUserProperties() {
            return userProperties == null ? null : userProperties.asByteBuffer();
        }

        public final void setUserProperties(ByteBuffer userProperties) {
            userProperties(userProperties == null ? null : SdkBytes.fromByteBuffer(userProperties));
        }

        @Override
        public final Builder userProperties(SdkBytes userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        @Override
        public GetRetainedMessageResponse build() {
            return new GetRetainedMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
