/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSuiteRunResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<StartSuiteRunResponse.Builder, StartSuiteRunResponse> {
    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunId").getter(getter(StartSuiteRunResponse::suiteRunId)).setter(setter(Builder::suiteRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()).build();

    private static final SdkField<String> SUITE_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunArn").getter(getter(StartSuiteRunResponse::suiteRunArn)).setter(setter(Builder::suiteRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(StartSuiteRunResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_RUN_ID_FIELD,
            SUITE_RUN_ARN_FIELD, CREATED_AT_FIELD));

    private final String suiteRunId;

    private final String suiteRunArn;

    private final Instant createdAt;

    private StartSuiteRunResponse(BuilderImpl builder) {
        super(builder);
        this.suiteRunId = builder.suiteRunId;
        this.suiteRunArn = builder.suiteRunArn;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * Suite Run Id of the started suite run.
     * </p>
     * 
     * @return Suite Run Id of the started suite run.
     */
    public final String suiteRunId() {
        return suiteRunId;
    }

    /**
     * <p>
     * Amazon resource name of the started suite run.
     * </p>
     * 
     * @return Amazon resource name of the started suite run.
     */
    public final String suiteRunArn() {
        return suiteRunArn;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite run was created.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSuiteRunResponse)) {
            return false;
        }
        StartSuiteRunResponse other = (StartSuiteRunResponse) obj;
        return Objects.equals(suiteRunId(), other.suiteRunId()) && Objects.equals(suiteRunArn(), other.suiteRunArn())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSuiteRunResponse").add("SuiteRunId", suiteRunId()).add("SuiteRunArn", suiteRunArn())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteRunId":
            return Optional.ofNullable(clazz.cast(suiteRunId()));
        case "suiteRunArn":
            return Optional.ofNullable(clazz.cast(suiteRunArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSuiteRunResponse, T> g) {
        return obj -> g.apply((StartSuiteRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSuiteRunResponse> {
        /**
         * <p>
         * Suite Run Id of the started suite run.
         * </p>
         * 
         * @param suiteRunId
         *        Suite Run Id of the started suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunId(String suiteRunId);

        /**
         * <p>
         * Amazon resource name of the started suite run.
         * </p>
         * 
         * @param suiteRunArn
         *        Amazon resource name of the started suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunArn(String suiteRunArn);

        /**
         * <p>
         * Date (in Unix epoch time) when the suite run was created.
         * </p>
         * 
         * @param createdAt
         *        Date (in Unix epoch time) when the suite run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteRunId;

        private String suiteRunArn;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSuiteRunResponse model) {
            super(model);
            suiteRunId(model.suiteRunId);
            suiteRunArn(model.suiteRunArn);
            createdAt(model.createdAt);
        }

        public final String getSuiteRunId() {
            return suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        public final String getSuiteRunArn() {
            return suiteRunArn;
        }

        @Override
        public final Builder suiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
            return this;
        }

        public final void setSuiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public StartSuiteRunResponse build() {
            return new StartSuiteRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
