/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuiteDefinitionResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<GetSuiteDefinitionResponse.Builder, GetSuiteDefinitionResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(GetSuiteDefinitionResponse::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionArn").getter(getter(GetSuiteDefinitionResponse::suiteDefinitionArn))
            .setter(setter(Builder::suiteDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionArn").build())
            .build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion").getter(getter(GetSuiteDefinitionResponse::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build())
            .build();

    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersion").getter(getter(GetSuiteDefinitionResponse::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<SuiteDefinitionConfiguration> SUITE_DEFINITION_CONFIGURATION_FIELD = SdkField
            .<SuiteDefinitionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("suiteDefinitionConfiguration")
            .getter(getter(GetSuiteDefinitionResponse::suiteDefinitionConfiguration))
            .setter(setter(Builder::suiteDefinitionConfiguration))
            .constructor(SuiteDefinitionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionConfiguration")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetSuiteDefinitionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(GetSuiteDefinitionResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSuiteDefinitionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_ARN_FIELD, SUITE_DEFINITION_VERSION_FIELD, LATEST_VERSION_FIELD,
            SUITE_DEFINITION_CONFIGURATION_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, TAGS_FIELD));

    private final String suiteDefinitionId;

    private final String suiteDefinitionArn;

    private final String suiteDefinitionVersion;

    private final String latestVersion;

    private final SuiteDefinitionConfiguration suiteDefinitionConfiguration;

    private final Instant createdAt;

    private final Instant lastModifiedAt;

    private final Map<String, String> tags;

    private GetSuiteDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionArn = builder.suiteDefinitionArn;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.latestVersion = builder.latestVersion;
        this.suiteDefinitionConfiguration = builder.suiteDefinitionConfiguration;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Suite definition ID of the suite definition.
     * </p>
     * 
     * @return Suite definition ID of the suite definition.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * The ARN of the suite definition.
     * </p>
     * 
     * @return The ARN of the suite definition.
     */
    public final String suiteDefinitionArn() {
        return suiteDefinitionArn;
    }

    /**
     * <p>
     * Suite definition version of the suite definition.
     * </p>
     * 
     * @return Suite definition version of the suite definition.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    /**
     * <p>
     * Latest suite definition version of the suite definition.
     * </p>
     * 
     * @return Latest suite definition version of the suite definition.
     */
    public final String latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * Suite configuration of the suite definition.
     * </p>
     * 
     * @return Suite configuration of the suite definition.
     */
    public final SuiteDefinitionConfiguration suiteDefinitionConfiguration() {
        return suiteDefinitionConfiguration;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite definition was created.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite definition was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite definition was last modified.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite definition was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the suite definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the suite definition.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteDefinitionResponse)) {
            return false;
        }
        GetSuiteDefinitionResponse other = (GetSuiteDefinitionResponse) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionArn(), other.suiteDefinitionArn())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(suiteDefinitionConfiguration(), other.suiteDefinitionConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuiteDefinitionResponse").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionArn", suiteDefinitionArn()).add("SuiteDefinitionVersion", suiteDefinitionVersion())
                .add("LatestVersion", latestVersion()).add("SuiteDefinitionConfiguration", suiteDefinitionConfiguration())
                .add("CreatedAt", createdAt()).add("LastModifiedAt", lastModifiedAt()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionArn":
            return Optional.ofNullable(clazz.cast(suiteDefinitionArn()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "suiteDefinitionConfiguration":
            return Optional.ofNullable(clazz.cast(suiteDefinitionConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteDefinitionResponse, T> g) {
        return obj -> g.apply((GetSuiteDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSuiteDefinitionResponse> {
        /**
         * <p>
         * Suite definition ID of the suite definition.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * The ARN of the suite definition.
         * </p>
         * 
         * @param suiteDefinitionArn
         *        The ARN of the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionArn(String suiteDefinitionArn);

        /**
         * <p>
         * Suite definition version of the suite definition.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version of the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        /**
         * <p>
         * Latest suite definition version of the suite definition.
         * </p>
         * 
         * @param latestVersion
         *        Latest suite definition version of the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(String latestVersion);

        /**
         * <p>
         * Suite configuration of the suite definition.
         * </p>
         * 
         * @param suiteDefinitionConfiguration
         *        Suite configuration of the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration);

        /**
         * <p>
         * Suite configuration of the suite definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuiteDefinitionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SuiteDefinitionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuiteDefinitionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)}.
         * 
         * @param suiteDefinitionConfiguration
         *        a consumer that will call methods on {@link SuiteDefinitionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)
         */
        default Builder suiteDefinitionConfiguration(Consumer<SuiteDefinitionConfiguration.Builder> suiteDefinitionConfiguration) {
            return suiteDefinitionConfiguration(SuiteDefinitionConfiguration.builder()
                    .applyMutation(suiteDefinitionConfiguration).build());
        }

        /**
         * <p>
         * Date (in Unix epoch time) when the suite definition was created.
         * </p>
         * 
         * @param createdAt
         *        Date (in Unix epoch time) when the suite definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Date (in Unix epoch time) when the suite definition was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        Date (in Unix epoch time) when the suite definition was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * Tags attached to the suite definition.
         * </p>
         * 
         * @param tags
         *        Tags attached to the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionArn;

        private String suiteDefinitionVersion;

        private String latestVersion;

        private SuiteDefinitionConfiguration suiteDefinitionConfiguration;

        private Instant createdAt;

        private Instant lastModifiedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteDefinitionResponse model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionArn(model.suiteDefinitionArn);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
            latestVersion(model.latestVersion);
            suiteDefinitionConfiguration(model.suiteDefinitionConfiguration);
            createdAt(model.createdAt);
            lastModifiedAt(model.lastModifiedAt);
            tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionArn() {
            return suiteDefinitionArn;
        }

        public final void setSuiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
        }

        @Override
        public final Builder suiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final SuiteDefinitionConfiguration.Builder getSuiteDefinitionConfiguration() {
            return suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.toBuilder() : null;
        }

        public final void setSuiteDefinitionConfiguration(SuiteDefinitionConfiguration.BuilderImpl suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSuiteDefinitionResponse build() {
            return new GetSuiteDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
