/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuiteRunResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<GetSuiteRunResponse.Builder, GetSuiteRunResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(GetSuiteRunResponse::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion").getter(getter(GetSuiteRunResponse::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build())
            .build();

    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunId").getter(getter(GetSuiteRunResponse::suiteRunId)).setter(setter(Builder::suiteRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()).build();

    private static final SdkField<String> SUITE_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunArn").getter(getter(GetSuiteRunResponse::suiteRunArn)).setter(setter(Builder::suiteRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunArn").build()).build();

    private static final SdkField<SuiteRunConfiguration> SUITE_RUN_CONFIGURATION_FIELD = SdkField
            .<SuiteRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("suiteRunConfiguration")
            .getter(getter(GetSuiteRunResponse::suiteRunConfiguration)).setter(setter(Builder::suiteRunConfiguration))
            .constructor(SuiteRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunConfiguration").build())
            .build();

    private static final SdkField<TestResult> TEST_RESULT_FIELD = SdkField.<TestResult> builder(MarshallingType.SDK_POJO)
            .memberName("testResult").getter(getter(GetSuiteRunResponse::testResult)).setter(setter(Builder::testResult))
            .constructor(TestResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testResult").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetSuiteRunResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetSuiteRunResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSuiteRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorReason").getter(getter(GetSuiteRunResponse::errorReason)).setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSuiteRunResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_VERSION_FIELD, SUITE_RUN_ID_FIELD, SUITE_RUN_ARN_FIELD, SUITE_RUN_CONFIGURATION_FIELD,
            TEST_RESULT_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ERROR_REASON_FIELD, TAGS_FIELD));

    private final String suiteDefinitionId;

    private final String suiteDefinitionVersion;

    private final String suiteRunId;

    private final String suiteRunArn;

    private final SuiteRunConfiguration suiteRunConfiguration;

    private final TestResult testResult;

    private final Instant startTime;

    private final Instant endTime;

    private final String status;

    private final String errorReason;

    private final Map<String, String> tags;

    private GetSuiteRunResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteRunId = builder.suiteRunId;
        this.suiteRunArn = builder.suiteRunArn;
        this.suiteRunConfiguration = builder.suiteRunConfiguration;
        this.testResult = builder.testResult;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.errorReason = builder.errorReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Suite definition ID for the test suite run.
     * </p>
     * 
     * @return Suite definition ID for the test suite run.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite definition version for the test suite run.
     * </p>
     * 
     * @return Suite definition version for the test suite run.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    /**
     * <p>
     * Suite run ID for the test suite run.
     * </p>
     * 
     * @return Suite run ID for the test suite run.
     */
    public final String suiteRunId() {
        return suiteRunId;
    }

    /**
     * <p>
     * The ARN of the suite run.
     * </p>
     * 
     * @return The ARN of the suite run.
     */
    public final String suiteRunArn() {
        return suiteRunArn;
    }

    /**
     * <p>
     * Suite run configuration for the test suite run.
     * </p>
     * 
     * @return Suite run configuration for the test suite run.
     */
    public final SuiteRunConfiguration suiteRunConfiguration() {
        return suiteRunConfiguration;
    }

    /**
     * <p>
     * Test results for the test suite run.
     * </p>
     * 
     * @return Test results for the test suite run.
     */
    public final TestResult testResult() {
        return testResult;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the test suite run started.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the test suite run started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the test suite run ended.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the test suite run ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Status for the test suite run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SuiteRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the test suite run.
     * @see SuiteRunStatus
     */
    public final SuiteRunStatus status() {
        return SuiteRunStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the test suite run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SuiteRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the test suite run.
     * @see SuiteRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error reason for any test suite run failure.
     * </p>
     * 
     * @return Error reason for any test suite run failure.
     */
    public final String errorReason() {
        return errorReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags attached to the suite run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags attached to the suite run.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(testResult());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteRunResponse)) {
            return false;
        }
        GetSuiteRunResponse other = (GetSuiteRunResponse) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion())
                && Objects.equals(suiteRunId(), other.suiteRunId()) && Objects.equals(suiteRunArn(), other.suiteRunArn())
                && Objects.equals(suiteRunConfiguration(), other.suiteRunConfiguration())
                && Objects.equals(testResult(), other.testResult()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorReason(), other.errorReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuiteRunResponse").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionVersion", suiteDefinitionVersion()).add("SuiteRunId", suiteRunId())
                .add("SuiteRunArn", suiteRunArn()).add("SuiteRunConfiguration", suiteRunConfiguration())
                .add("TestResult", testResult()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Status", statusAsString()).add("ErrorReason", errorReason()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        case "suiteRunId":
            return Optional.ofNullable(clazz.cast(suiteRunId()));
        case "suiteRunArn":
            return Optional.ofNullable(clazz.cast(suiteRunArn()));
        case "suiteRunConfiguration":
            return Optional.ofNullable(clazz.cast(suiteRunConfiguration()));
        case "testResult":
            return Optional.ofNullable(clazz.cast(testResult()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteRunResponse, T> g) {
        return obj -> g.apply((GetSuiteRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSuiteRunResponse> {
        /**
         * <p>
         * Suite definition ID for the test suite run.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID for the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite definition version for the test suite run.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version for the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        /**
         * <p>
         * Suite run ID for the test suite run.
         * </p>
         * 
         * @param suiteRunId
         *        Suite run ID for the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunId(String suiteRunId);

        /**
         * <p>
         * The ARN of the suite run.
         * </p>
         * 
         * @param suiteRunArn
         *        The ARN of the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunArn(String suiteRunArn);

        /**
         * <p>
         * Suite run configuration for the test suite run.
         * </p>
         * 
         * @param suiteRunConfiguration
         *        Suite run configuration for the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration);

        /**
         * <p>
         * Suite run configuration for the test suite run.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuiteRunConfiguration.Builder} avoiding
         * the need to create one manually via {@link SuiteRunConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuiteRunConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #suiteRunConfiguration(SuiteRunConfiguration)}.
         * 
         * @param suiteRunConfiguration
         *        a consumer that will call methods on {@link SuiteRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteRunConfiguration(SuiteRunConfiguration)
         */
        default Builder suiteRunConfiguration(Consumer<SuiteRunConfiguration.Builder> suiteRunConfiguration) {
            return suiteRunConfiguration(SuiteRunConfiguration.builder().applyMutation(suiteRunConfiguration).build());
        }

        /**
         * <p>
         * Test results for the test suite run.
         * </p>
         * 
         * @param testResult
         *        Test results for the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testResult(TestResult testResult);

        /**
         * <p>
         * Test results for the test suite run.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestResult.Builder} avoiding the need to
         * create one manually via {@link TestResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestResult.Builder#build()} is called immediately and its result
         * is passed to {@link #testResult(TestResult)}.
         * 
         * @param testResult
         *        a consumer that will call methods on {@link TestResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testResult(TestResult)
         */
        default Builder testResult(Consumer<TestResult.Builder> testResult) {
            return testResult(TestResult.builder().applyMutation(testResult).build());
        }

        /**
         * <p>
         * Date (in Unix epoch time) when the test suite run started.
         * </p>
         * 
         * @param startTime
         *        Date (in Unix epoch time) when the test suite run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Date (in Unix epoch time) when the test suite run ended.
         * </p>
         * 
         * @param endTime
         *        Date (in Unix epoch time) when the test suite run ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Status for the test suite run.
         * </p>
         * 
         * @param status
         *        Status for the test suite run.
         * @see SuiteRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuiteRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the test suite run.
         * </p>
         * 
         * @param status
         *        Status for the test suite run.
         * @see SuiteRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuiteRunStatus
         */
        Builder status(SuiteRunStatus status);

        /**
         * <p>
         * Error reason for any test suite run failure.
         * </p>
         * 
         * @param errorReason
         *        Error reason for any test suite run failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);

        /**
         * <p>
         * The tags attached to the suite run.
         * </p>
         * 
         * @param tags
         *        The tags attached to the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionVersion;

        private String suiteRunId;

        private String suiteRunArn;

        private SuiteRunConfiguration suiteRunConfiguration;

        private TestResult testResult;

        private Instant startTime;

        private Instant endTime;

        private String status;

        private String errorReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteRunResponse model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
            suiteRunId(model.suiteRunId);
            suiteRunArn(model.suiteRunArn);
            suiteRunConfiguration(model.suiteRunConfiguration);
            testResult(model.testResult);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            errorReason(model.errorReason);
            tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getSuiteRunId() {
            return suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final String getSuiteRunArn() {
            return suiteRunArn;
        }

        public final void setSuiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
        }

        @Override
        public final Builder suiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
            return this;
        }

        public final SuiteRunConfiguration.Builder getSuiteRunConfiguration() {
            return suiteRunConfiguration != null ? suiteRunConfiguration.toBuilder() : null;
        }

        public final void setSuiteRunConfiguration(SuiteRunConfiguration.BuilderImpl suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration != null ? suiteRunConfiguration.build() : null;
        }

        @Override
        public final Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration;
            return this;
        }

        public final TestResult.Builder getTestResult() {
            return testResult != null ? testResult.toBuilder() : null;
        }

        public final void setTestResult(TestResult.BuilderImpl testResult) {
            this.testResult = testResult != null ? testResult.build() : null;
        }

        @Override
        public final Builder testResult(TestResult testResult) {
            this.testResult = testResult;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SuiteRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSuiteRunResponse build() {
            return new GetSuiteRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
