/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Show each group result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestResult implements SdkPojo, Serializable, ToCopyableBuilder<TestResult.Builder, TestResult> {
    private static final SdkField<List<GroupResult>> GROUPS_FIELD = SdkField
            .<List<GroupResult>> builder(MarshallingType.LIST)
            .memberName("groups")
            .getter(getter(TestResult::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GroupResult> groups;

    private TestResult(BuilderImpl builder) {
        this.groups = builder.groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Show each group of test results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Show each group of test results.
     */
    public final List<GroupResult> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestResult").add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestResult, T> g) {
        return obj -> g.apply((TestResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestResult> {
        /**
         * <p>
         * Show each group of test results.
         * </p>
         * 
         * @param groups
         *        Show each group of test results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupResult> groups);

        /**
         * <p>
         * Show each group of test results.
         * </p>
         * 
         * @param groups
         *        Show each group of test results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupResult... groups);

        /**
         * <p>
         * Show each group of test results.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GroupResult>.Builder} avoiding the
         * need to create one manually via {@link List<GroupResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #groups(List<GroupResult>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupResult>)
         */
        Builder groups(Consumer<GroupResult.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupResult> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestResult model) {
            groups(model.groups);
        }

        public final List<GroupResult.Builder> getGroups() {
            List<GroupResult.Builder> result = GroupResultListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupResult.BuilderImpl> groups) {
            this.groups = GroupResultListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupResult> groups) {
            this.groups = GroupResultListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupResult... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupResult.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestResult build() {
            return new TestResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
