/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the suite definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuiteDefinitionInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SuiteDefinitionInformation.Builder, SuiteDefinitionInformation> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(SuiteDefinitionInformation::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(SuiteDefinitionInformation::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<List<DeviceUnderTest>> DEFAULT_DEVICES_FIELD = SdkField
            .<List<DeviceUnderTest>> builder(MarshallingType.LIST)
            .memberName("defaultDevices")
            .getter(getter(SuiteDefinitionInformation::defaultDevices))
            .setter(setter(Builder::defaultDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceUnderTest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceUnderTest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INTENDED_FOR_QUALIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("intendedForQualification").getter(getter(SuiteDefinitionInformation::intendedForQualification))
            .setter(setter(Builder::intendedForQualification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intendedForQualification").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SuiteDefinitionInformation::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_NAME_FIELD, DEFAULT_DEVICES_FIELD, INTENDED_FOR_QUALIFICATION_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String suiteDefinitionId;

    private final String suiteDefinitionName;

    private final List<DeviceUnderTest> defaultDevices;

    private final Boolean intendedForQualification;

    private final Instant createdAt;

    private SuiteDefinitionInformation(BuilderImpl builder) {
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.defaultDevices = builder.defaultDevices;
        this.intendedForQualification = builder.intendedForQualification;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * Suite definition ID of the test suite.
     * </p>
     * 
     * @return Suite definition ID of the test suite.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite name of the test suite.
     * </p>
     * 
     * @return Suite name of the test suite.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultDevices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultDevices() {
        return defaultDevices != null && !(defaultDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the devices under test for the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultDevices} method.
     * </p>
     * 
     * @return Specifies the devices under test for the test suite.
     */
    public final List<DeviceUnderTest> defaultDevices() {
        return defaultDevices;
    }

    /**
     * <p>
     * Specifies if the test suite is intended for qualification.
     * </p>
     * 
     * @return Specifies if the test suite is intended for qualification.
     */
    public final Boolean intendedForQualification() {
        return intendedForQualification;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the test suite was created.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the test suite was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultDevices() ? defaultDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intendedForQualification());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionInformation)) {
            return false;
        }
        SuiteDefinitionInformation other = (SuiteDefinitionInformation) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionName(), other.suiteDefinitionName())
                && hasDefaultDevices() == other.hasDefaultDevices() && Objects.equals(defaultDevices(), other.defaultDevices())
                && Objects.equals(intendedForQualification(), other.intendedForQualification())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuiteDefinitionInformation").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionName", suiteDefinitionName())
                .add("DefaultDevices", hasDefaultDevices() ? defaultDevices() : null)
                .add("IntendedForQualification", intendedForQualification()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "defaultDevices":
            return Optional.ofNullable(clazz.cast(defaultDevices()));
        case "intendedForQualification":
            return Optional.ofNullable(clazz.cast(intendedForQualification()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteDefinitionInformation, T> g) {
        return obj -> g.apply((SuiteDefinitionInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuiteDefinitionInformation> {
        /**
         * <p>
         * Suite definition ID of the test suite.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite name of the test suite.
         * </p>
         * 
         * @param suiteDefinitionName
         *        Suite name of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * Specifies the devices under test for the test suite.
         * </p>
         * 
         * @param defaultDevices
         *        Specifies the devices under test for the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDevices(Collection<DeviceUnderTest> defaultDevices);

        /**
         * <p>
         * Specifies the devices under test for the test suite.
         * </p>
         * 
         * @param defaultDevices
         *        Specifies the devices under test for the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDevices(DeviceUnderTest... defaultDevices);

        /**
         * <p>
         * Specifies the devices under test for the test suite.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceUnderTest>.Builder} avoiding the need
         * to create one manually via {@link List<DeviceUnderTest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceUnderTest>.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultDevices(List<DeviceUnderTest>)}.
         * 
         * @param defaultDevices
         *        a consumer that will call methods on {@link List<DeviceUnderTest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultDevices(List<DeviceUnderTest>)
         */
        Builder defaultDevices(Consumer<DeviceUnderTest.Builder>... defaultDevices);

        /**
         * <p>
         * Specifies if the test suite is intended for qualification.
         * </p>
         * 
         * @param intendedForQualification
         *        Specifies if the test suite is intended for qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intendedForQualification(Boolean intendedForQualification);

        /**
         * <p>
         * Date (in Unix epoch time) when the test suite was created.
         * </p>
         * 
         * @param createdAt
         *        Date (in Unix epoch time) when the test suite was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionName;

        private List<DeviceUnderTest> defaultDevices = DefaultSdkAutoConstructList.getInstance();

        private Boolean intendedForQualification;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteDefinitionInformation model) {
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionName(model.suiteDefinitionName);
            defaultDevices(model.defaultDevices);
            intendedForQualification(model.intendedForQualification);
            createdAt(model.createdAt);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final List<DeviceUnderTest.Builder> getDefaultDevices() {
            List<DeviceUnderTest.Builder> result = DeviceUnderTestListCopier.copyToBuilder(this.defaultDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultDevices(Collection<DeviceUnderTest.BuilderImpl> defaultDevices) {
            this.defaultDevices = DeviceUnderTestListCopier.copyFromBuilder(defaultDevices);
        }

        @Override
        @Transient
        public final Builder defaultDevices(Collection<DeviceUnderTest> defaultDevices) {
            this.defaultDevices = DeviceUnderTestListCopier.copy(defaultDevices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultDevices(DeviceUnderTest... defaultDevices) {
            defaultDevices(Arrays.asList(defaultDevices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultDevices(Consumer<DeviceUnderTest.Builder>... defaultDevices) {
            defaultDevices(Stream.of(defaultDevices).map(c -> DeviceUnderTest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIntendedForQualification() {
            return intendedForQualification;
        }

        public final void setIntendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
        }

        @Override
        @Transient
        public final Builder intendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public SuiteDefinitionInformation build() {
            return new SuiteDefinitionInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
