/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSuiteDefinitionRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<UpdateSuiteDefinitionRequest.Builder, UpdateSuiteDefinitionRequest> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(UpdateSuiteDefinitionRequest::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<SuiteDefinitionConfiguration> SUITE_DEFINITION_CONFIGURATION_FIELD = SdkField
            .<SuiteDefinitionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("suiteDefinitionConfiguration")
            .getter(getter(UpdateSuiteDefinitionRequest::suiteDefinitionConfiguration))
            .setter(setter(Builder::suiteDefinitionConfiguration))
            .constructor(SuiteDefinitionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_CONFIGURATION_FIELD));

    private final String suiteDefinitionId;

    private final SuiteDefinitionConfiguration suiteDefinitionConfiguration;

    private UpdateSuiteDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionConfiguration = builder.suiteDefinitionConfiguration;
    }

    /**
     * <p>
     * Suite definition ID of the test suite to be updated.
     * </p>
     * 
     * @return Suite definition ID of the test suite to be updated.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Updates a Device Advisor test suite with suite definition configuration.
     * </p>
     * 
     * @return Updates a Device Advisor test suite with suite definition configuration.
     */
    public final SuiteDefinitionConfiguration suiteDefinitionConfiguration() {
        return suiteDefinitionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSuiteDefinitionRequest)) {
            return false;
        }
        UpdateSuiteDefinitionRequest other = (UpdateSuiteDefinitionRequest) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionConfiguration(), other.suiteDefinitionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSuiteDefinitionRequest").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionConfiguration", suiteDefinitionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionConfiguration":
            return Optional.ofNullable(clazz.cast(suiteDefinitionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSuiteDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateSuiteDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSuiteDefinitionRequest> {
        /**
         * <p>
         * Suite definition ID of the test suite to be updated.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the test suite to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Updates a Device Advisor test suite with suite definition configuration.
         * </p>
         * 
         * @param suiteDefinitionConfiguration
         *        Updates a Device Advisor test suite with suite definition configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration);

        /**
         * <p>
         * Updates a Device Advisor test suite with suite definition configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SuiteDefinitionConfiguration.Builder} avoiding
         * the need to create one manually via {@link SuiteDefinitionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuiteDefinitionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)}.
         * 
         * @param suiteDefinitionConfiguration
         *        a consumer that will call methods on {@link SuiteDefinitionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)
         */
        default Builder suiteDefinitionConfiguration(Consumer<SuiteDefinitionConfiguration.Builder> suiteDefinitionConfiguration) {
            return suiteDefinitionConfiguration(SuiteDefinitionConfiguration.builder()
                    .applyMutation(suiteDefinitionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private SuiteDefinitionConfiguration suiteDefinitionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSuiteDefinitionRequest model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionConfiguration(model.suiteDefinitionConfiguration);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final SuiteDefinitionConfiguration.Builder getSuiteDefinitionConfiguration() {
            return suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.toBuilder() : null;
        }

        public final void setSuiteDefinitionConfiguration(SuiteDefinitionConfiguration.BuilderImpl suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSuiteDefinitionRequest build() {
            return new UpdateSuiteDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
