/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsPublisher;
import software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsPublisher;

/**
 * Service client for accessing AWSIoTDeviceAdvisor asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT
 * devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT
 * devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to
 * production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core,
 * follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also
 * download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device
 * qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it
 * to be tested.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotDeviceAdvisorAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotdeviceadvisor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotdeviceadvisor";

    /**
     * <p>
     * Creates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSuiteDefinition</a> action.
     * </p>
     *
     * @param createSuiteDefinitionRequest
     * @return A Java Future containing the result of the CreateSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.CreateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSuiteDefinitionResponse> createSuiteDefinition(
            CreateSuiteDefinitionRequest createSuiteDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param createSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.CreateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSuiteDefinitionResponse> createSuiteDefinition(
            Consumer<CreateSuiteDefinitionRequest.Builder> createSuiteDefinitionRequest) {
        return createSuiteDefinition(CreateSuiteDefinitionRequest.builder().applyMutation(createSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSuiteDefinition</a> action.
     * </p>
     *
     * @param deleteSuiteDefinitionRequest
     * @return A Java Future containing the result of the DeleteSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.DeleteSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSuiteDefinitionResponse> deleteSuiteDefinition(
            DeleteSuiteDefinitionRequest deleteSuiteDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.DeleteSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSuiteDefinitionResponse> deleteSuiteDefinition(
            Consumer<DeleteSuiteDefinitionRequest.Builder> deleteSuiteDefinitionRequest) {
        return deleteSuiteDefinition(DeleteSuiteDefinitionRequest.builder().applyMutation(deleteSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Gets information about an Device Advisor endpoint.
     * </p>
     *
     * @param getEndpointRequest
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEndpointResponse> getEndpoint(GetEndpointRequest getEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an Device Advisor endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetEndpointRequest#builder()}
     * </p>
     *
     * @param getEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEndpointResponse> getEndpoint(Consumer<GetEndpointRequest.Builder> getEndpointRequest) {
        return getEndpoint(GetEndpointRequest.builder().applyMutation(getEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteDefinition</a> action.
     * </p>
     *
     * @param getSuiteDefinitionRequest
     * @return A Java Future containing the result of the GetSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuiteDefinitionResponse> getSuiteDefinition(GetSuiteDefinitionRequest getSuiteDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param getSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuiteDefinitionResponse> getSuiteDefinition(
            Consumer<GetSuiteDefinitionRequest.Builder> getSuiteDefinitionRequest) {
        return getSuiteDefinition(GetSuiteDefinitionRequest.builder().applyMutation(getSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRun</a> action.
     * </p>
     *
     * @param getSuiteRunRequest
     * @return A Java Future containing the result of the GetSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSuiteRunResponse> getSuiteRun(GetSuiteRunRequest getSuiteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetSuiteRunRequest#builder()}
     * </p>
     *
     * @param getSuiteRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSuiteRunResponse> getSuiteRun(Consumer<GetSuiteRunRequest.Builder> getSuiteRunRequest) {
        return getSuiteRun(GetSuiteRunRequest.builder().applyMutation(getSuiteRunRequest).build());
    }

    /**
     * <p>
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRunReport</a> action.
     * </p>
     *
     * @param getSuiteRunReportRequest
     * @return A Java Future containing the result of the GetSuiteRunReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteRunReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuiteRunReportResponse> getSuiteRunReport(GetSuiteRunReportRequest getSuiteRunReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRunReport</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRunReportRequest.Builder} avoiding the need
     * to create one manually via {@link GetSuiteRunReportRequest#builder()}
     * </p>
     *
     * @param getSuiteRunReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetSuiteRunReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.GetSuiteRunReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuiteRunReportResponse> getSuiteRunReport(
            Consumer<GetSuiteRunReportRequest.Builder> getSuiteRunReportRequest) {
        return getSuiteRunReport(GetSuiteRunReportRequest.builder().applyMutation(getSuiteRunReportRequest).build());
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     * @return A Java Future containing the result of the ListSuiteDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuiteDefinitionsResponse> listSuiteDefinitions(
            ListSuiteDefinitionsRequest listSuiteDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSuiteDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSuiteDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuiteDefinitionsResponse> listSuiteDefinitions(
            Consumer<ListSuiteDefinitionsRequest.Builder> listSuiteDefinitionsRequest) {
        return listSuiteDefinitions(ListSuiteDefinitionsRequest.builder().applyMutation(listSuiteDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsPublisher publisher = client.listSuiteDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsPublisher publisher = client.listSuiteDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsPublisher listSuiteDefinitionsPaginator(ListSuiteDefinitionsRequest listSuiteDefinitionsRequest) {
        return new ListSuiteDefinitionsPublisher(this, listSuiteDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsPublisher publisher = client.listSuiteDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsPublisher publisher = client.listSuiteDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSuiteDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsPublisher listSuiteDefinitionsPaginator(
            Consumer<ListSuiteDefinitionsRequest.Builder> listSuiteDefinitionsRequest) {
        return listSuiteDefinitionsPaginator(ListSuiteDefinitionsRequest.builder().applyMutation(listSuiteDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     *
     * @param listSuiteRunsRequest
     * @return A Java Future containing the result of the ListSuiteRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuiteRunsResponse> listSuiteRuns(ListSuiteRunsRequest listSuiteRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuiteRunsRequest#builder()}
     * </p>
     *
     * @param listSuiteRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSuiteRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuiteRunsResponse> listSuiteRuns(Consumer<ListSuiteRunsRequest.Builder> listSuiteRunsRequest) {
        return listSuiteRuns(ListSuiteRunsRequest.builder().applyMutation(listSuiteRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsPublisher publisher = client.listSuiteRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsPublisher publisher = client.listSuiteRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuiteRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsPublisher listSuiteRunsPaginator(ListSuiteRunsRequest listSuiteRunsRequest) {
        return new ListSuiteRunsPublisher(this, listSuiteRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsPublisher publisher = client.listSuiteRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsPublisher publisher = client.listSuiteRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuiteRunsRequest#builder()}
     * </p>
     *
     * @param listSuiteRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsPublisher listSuiteRunsPaginator(Consumer<ListSuiteRunsRequest.Builder> listSuiteRunsRequest) {
        return listSuiteRunsPaginator(ListSuiteRunsRequest.builder().applyMutation(listSuiteRunsRequest).build());
    }

    /**
     * <p>
     * Lists the tags attached to an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTagsForResource</a> action.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags attached to an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTagsForResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartSuiteRun</a> action.
     * </p>
     *
     * @param startSuiteRunRequest
     * @return A Java Future containing the result of the StartSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ConflictException Sends a Conflict Exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.StartSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSuiteRunResponse> startSuiteRun(StartSuiteRunRequest startSuiteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartSuiteRunRequest#builder()}
     * </p>
     *
     * @param startSuiteRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ConflictException Sends a Conflict Exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.StartSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSuiteRunResponse> startSuiteRun(Consumer<StartSuiteRunRequest.Builder> startSuiteRunRequest) {
        return startSuiteRun(StartSuiteRunRequest.builder().applyMutation(startSuiteRunRequest).build());
    }

    /**
     * <p>
     * Stops a Device Advisor test suite run that is currently running.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StopSuiteRun</a> action.
     * </p>
     *
     * @param stopSuiteRunRequest
     * @return A Java Future containing the result of the StopSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.StopSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSuiteRunResponse> stopSuiteRun(StopSuiteRunRequest stopSuiteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a Device Advisor test suite run that is currently running.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StopSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link StopSuiteRunRequest#builder()}
     * </p>
     *
     * @param stopSuiteRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopSuiteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.StopSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSuiteRunResponse> stopSuiteRun(Consumer<StopSuiteRunRequest.Builder> stopSuiteRunRequest) {
        return stopSuiteRun(StopSuiteRunRequest.builder().applyMutation(stopSuiteRunRequest).build());
    }

    /**
     * <p>
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TagResource</a> action.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TagResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UntagResource</a> action.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UntagResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>ResourceNotFoundException Sends a Resource Not Found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateSuiteDefinition</a> action.
     * </p>
     *
     * @param updateSuiteDefinitionRequest
     * @return A Java Future containing the result of the UpdateSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.UpdateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSuiteDefinitionResponse> updateSuiteDefinition(
            UpdateSuiteDefinitionRequest updateSuiteDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param updateSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSuiteDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Sends a validation exception.</li>
     *         <li>InternalServerException Sends an Internal Failure exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotDeviceAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotDeviceAdvisorAsyncClient.UpdateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSuiteDefinitionResponse> updateSuiteDefinition(
            Consumer<UpdateSuiteDefinitionRequest.Builder> updateSuiteDefinitionRequest) {
        return updateSuiteDefinition(UpdateSuiteDefinitionRequest.builder().applyMutation(updateSuiteDefinitionRequest).build());
    }

    @Override
    default IotDeviceAdvisorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotDeviceAdvisorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotDeviceAdvisorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotDeviceAdvisorAsyncClient}.
     */
    static IotDeviceAdvisorAsyncClientBuilder builder() {
        return new DefaultIotDeviceAdvisorAsyncClientBuilder();
    }
}
