/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information of a test device. A thing ARN, certificate ARN or device role ARN is required.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceUnderTest implements SdkPojo, Serializable, ToCopyableBuilder<DeviceUnderTest.Builder, DeviceUnderTest> {
    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(DeviceUnderTest::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(DeviceUnderTest::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> DEVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceRoleArn").getter(getter(DeviceUnderTest::deviceRoleArn)).setter(setter(Builder::deviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_ARN_FIELD,
            CERTIFICATE_ARN_FIELD, DEVICE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thingArn;

    private final String certificateArn;

    private final String deviceRoleArn;

    private DeviceUnderTest(BuilderImpl builder) {
        this.thingArn = builder.thingArn;
        this.certificateArn = builder.certificateArn;
        this.deviceRoleArn = builder.deviceRoleArn;
    }

    /**
     * <p>
     * Lists device's thing ARN.
     * </p>
     * 
     * @return Lists device's thing ARN.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * Lists device's certificate ARN.
     * </p>
     * 
     * @return Lists device's certificate ARN.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * Lists device's role ARN.
     * </p>
     * 
     * @return Lists device's role ARN.
     */
    public final String deviceRoleArn() {
        return deviceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceUnderTest)) {
            return false;
        }
        DeviceUnderTest other = (DeviceUnderTest) obj;
        return Objects.equals(thingArn(), other.thingArn()) && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(deviceRoleArn(), other.deviceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceUnderTest").add("ThingArn", thingArn()).add("CertificateArn", certificateArn())
                .add("DeviceRoleArn", deviceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "deviceRoleArn":
            return Optional.ofNullable(clazz.cast(deviceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingArn", THING_ARN_FIELD);
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("deviceRoleArn", DEVICE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceUnderTest, T> g) {
        return obj -> g.apply((DeviceUnderTest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceUnderTest> {
        /**
         * <p>
         * Lists device's thing ARN.
         * </p>
         * 
         * @param thingArn
         *        Lists device's thing ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * Lists device's certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        Lists device's certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * Lists device's role ARN.
         * </p>
         * 
         * @param deviceRoleArn
         *        Lists device's role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRoleArn(String deviceRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String thingArn;

        private String certificateArn;

        private String deviceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceUnderTest model) {
            thingArn(model.thingArn);
            certificateArn(model.certificateArn);
            deviceRoleArn(model.deviceRoleArn);
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDeviceRoleArn() {
            return deviceRoleArn;
        }

        public final void setDeviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
        }

        @Override
        public final Builder deviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
            return this;
        }

        @Override
        public DeviceUnderTest build() {
            return new DeviceUnderTest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
