/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEndpointRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<GetEndpointRequest.Builder, GetEndpointRequest> {
    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(GetEndpointRequest::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(GetEndpointRequest::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificateArn").build())
            .build();

    private static final SdkField<String> DEVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceRoleArn").getter(getter(GetEndpointRequest::deviceRoleArn)).setter(setter(Builder::deviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceRoleArn").build()).build();

    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationMethod").getter(getter(GetEndpointRequest::authenticationMethodAsString))
            .setter(setter(Builder::authenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("authenticationMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_ARN_FIELD,
            CERTIFICATE_ARN_FIELD, DEVICE_ROLE_ARN_FIELD, AUTHENTICATION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingArn;

    private final String certificateArn;

    private final String deviceRoleArn;

    private final String authenticationMethod;

    private GetEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.thingArn = builder.thingArn;
        this.certificateArn = builder.certificateArn;
        this.deviceRoleArn = builder.deviceRoleArn;
        this.authenticationMethod = builder.authenticationMethod;
    }

    /**
     * <p>
     * The thing ARN of the device. This is an optional parameter.
     * </p>
     * 
     * @return The thing ARN of the device. This is an optional parameter.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * The certificate ARN of the device. This is an optional parameter.
     * </p>
     * 
     * @return The certificate ARN of the device. This is an optional parameter.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The device role ARN of the device. This is an optional parameter.
     * </p>
     * 
     * @return The device role ARN of the device. This is an optional parameter.
     */
    public final String deviceRoleArn() {
        return deviceRoleArn;
    }

    /**
     * <p>
     * The authentication method used during the device connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link AuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return The authentication method used during the device connection.
     * @see AuthenticationMethod
     */
    public final AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.fromValue(authenticationMethod);
    }

    /**
     * <p>
     * The authentication method used during the device connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link AuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return The authentication method used during the device connection.
     * @see AuthenticationMethod
     */
    public final String authenticationMethodAsString() {
        return authenticationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEndpointRequest)) {
            return false;
        }
        GetEndpointRequest other = (GetEndpointRequest) obj;
        return Objects.equals(thingArn(), other.thingArn()) && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(deviceRoleArn(), other.deviceRoleArn())
                && Objects.equals(authenticationMethodAsString(), other.authenticationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEndpointRequest").add("ThingArn", thingArn()).add("CertificateArn", certificateArn())
                .add("DeviceRoleArn", deviceRoleArn()).add("AuthenticationMethod", authenticationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "deviceRoleArn":
            return Optional.ofNullable(clazz.cast(deviceRoleArn()));
        case "authenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingArn", THING_ARN_FIELD);
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("deviceRoleArn", DEVICE_ROLE_ARN_FIELD);
        map.put("authenticationMethod", AUTHENTICATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEndpointRequest, T> g) {
        return obj -> g.apply((GetEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEndpointRequest> {
        /**
         * <p>
         * The thing ARN of the device. This is an optional parameter.
         * </p>
         * 
         * @param thingArn
         *        The thing ARN of the device. This is an optional parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * The certificate ARN of the device. This is an optional parameter.
         * </p>
         * 
         * @param certificateArn
         *        The certificate ARN of the device. This is an optional parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The device role ARN of the device. This is an optional parameter.
         * </p>
         * 
         * @param deviceRoleArn
         *        The device role ARN of the device. This is an optional parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRoleArn(String deviceRoleArn);

        /**
         * <p>
         * The authentication method used during the device connection.
         * </p>
         * 
         * @param authenticationMethod
         *        The authentication method used during the device connection.
         * @see AuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethod
         */
        Builder authenticationMethod(String authenticationMethod);

        /**
         * <p>
         * The authentication method used during the device connection.
         * </p>
         * 
         * @param authenticationMethod
         *        The authentication method used during the device connection.
         * @see AuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethod
         */
        Builder authenticationMethod(AuthenticationMethod authenticationMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private String thingArn;

        private String certificateArn;

        private String deviceRoleArn;

        private String authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEndpointRequest model) {
            super(model);
            thingArn(model.thingArn);
            certificateArn(model.certificateArn);
            deviceRoleArn(model.deviceRoleArn);
            authenticationMethod(model.authenticationMethod);
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDeviceRoleArn() {
            return deviceRoleArn;
        }

        public final void setDeviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
        }

        @Override
        public final Builder deviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
            return this;
        }

        public final String getAuthenticationMethod() {
            return authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEndpointRequest build() {
            return new GetEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
