/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuiteDefinitionRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<GetSuiteDefinitionRequest.Builder, GetSuiteDefinitionRequest> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(GetSuiteDefinitionRequest::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion")
            .getter(getter(GetSuiteDefinitionRequest::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("suiteDefinitionVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String suiteDefinitionId;

    private final String suiteDefinitionVersion;

    private GetSuiteDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
    }

    /**
     * <p>
     * Suite definition ID of the test suite to get.
     * </p>
     * 
     * @return Suite definition ID of the test suite to get.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite definition version of the test suite to get.
     * </p>
     * 
     * @return Suite definition version of the test suite to get.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteDefinitionRequest)) {
            return false;
        }
        GetSuiteDefinitionRequest other = (GetSuiteDefinitionRequest) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuiteDefinitionRequest").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionVersion", suiteDefinitionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteDefinitionRequest, T> g) {
        return obj -> g.apply((GetSuiteDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSuiteDefinitionRequest> {
        /**
         * <p>
         * Suite definition ID of the test suite to get.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the test suite to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite definition version of the test suite to get.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version of the test suite to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteDefinitionRequest model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSuiteDefinitionRequest build() {
            return new GetSuiteDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
