/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSuiteRunRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<StartSuiteRunRequest.Builder, StartSuiteRunRequest> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(StartSuiteRunRequest::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion").getter(getter(StartSuiteRunRequest::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build())
            .build();

    private static final SdkField<SuiteRunConfiguration> SUITE_RUN_CONFIGURATION_FIELD = SdkField
            .<SuiteRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("suiteRunConfiguration")
            .getter(getter(StartSuiteRunRequest::suiteRunConfiguration)).setter(setter(Builder::suiteRunConfiguration))
            .constructor(SuiteRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartSuiteRunRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_VERSION_FIELD, SUITE_RUN_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String suiteDefinitionId;

    private final String suiteDefinitionVersion;

    private final SuiteRunConfiguration suiteRunConfiguration;

    private final Map<String, String> tags;

    private StartSuiteRunRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteRunConfiguration = builder.suiteRunConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Suite definition ID of the test suite.
     * </p>
     * 
     * @return Suite definition ID of the test suite.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite definition version of the test suite.
     * </p>
     * 
     * @return Suite definition version of the test suite.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    /**
     * <p>
     * Suite run configuration.
     * </p>
     * 
     * @return Suite run configuration.
     */
    public final SuiteRunConfiguration suiteRunConfiguration() {
        return suiteRunConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be attached to the suite run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be attached to the suite run.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSuiteRunRequest)) {
            return false;
        }
        StartSuiteRunRequest other = (StartSuiteRunRequest) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion())
                && Objects.equals(suiteRunConfiguration(), other.suiteRunConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSuiteRunRequest").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionVersion", suiteDefinitionVersion()).add("SuiteRunConfiguration", suiteRunConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        case "suiteRunConfiguration":
            return Optional.ofNullable(clazz.cast(suiteRunConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
        map.put("suiteRunConfiguration", SUITE_RUN_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSuiteRunRequest, T> g) {
        return obj -> g.apply((StartSuiteRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSuiteRunRequest> {
        /**
         * <p>
         * Suite definition ID of the test suite.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite definition version of the test suite.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        /**
         * <p>
         * Suite run configuration.
         * </p>
         * 
         * @param suiteRunConfiguration
         *        Suite run configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration);

        /**
         * <p>
         * Suite run configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuiteRunConfiguration.Builder} avoiding
         * the need to create one manually via {@link SuiteRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuiteRunConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #suiteRunConfiguration(SuiteRunConfiguration)}.
         * 
         * @param suiteRunConfiguration
         *        a consumer that will call methods on {@link SuiteRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteRunConfiguration(SuiteRunConfiguration)
         */
        default Builder suiteRunConfiguration(Consumer<SuiteRunConfiguration.Builder> suiteRunConfiguration) {
            return suiteRunConfiguration(SuiteRunConfiguration.builder().applyMutation(suiteRunConfiguration).build());
        }

        /**
         * <p>
         * The tags to be attached to the suite run.
         * </p>
         * 
         * @param tags
         *        The tags to be attached to the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionVersion;

        private SuiteRunConfiguration suiteRunConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSuiteRunRequest model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
            suiteRunConfiguration(model.suiteRunConfiguration);
            tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final SuiteRunConfiguration.Builder getSuiteRunConfiguration() {
            return suiteRunConfiguration != null ? suiteRunConfiguration.toBuilder() : null;
        }

        public final void setSuiteRunConfiguration(SuiteRunConfiguration.BuilderImpl suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration != null ? suiteRunConfiguration.build() : null;
        }

        @Override
        public final Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSuiteRunRequest build() {
            return new StartSuiteRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
