/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSuiteRunResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<StartSuiteRunResponse.Builder, StartSuiteRunResponse> {
    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunId").getter(getter(StartSuiteRunResponse::suiteRunId)).setter(setter(Builder::suiteRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()).build();

    private static final SdkField<String> SUITE_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunArn").getter(getter(StartSuiteRunResponse::suiteRunArn)).setter(setter(Builder::suiteRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(StartSuiteRunResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(StartSuiteRunResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_RUN_ID_FIELD,
            SUITE_RUN_ARN_FIELD, CREATED_AT_FIELD, ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String suiteRunId;

    private final String suiteRunArn;

    private final Instant createdAt;

    private final String endpoint;

    private StartSuiteRunResponse(BuilderImpl builder) {
        super(builder);
        this.suiteRunId = builder.suiteRunId;
        this.suiteRunArn = builder.suiteRunArn;
        this.createdAt = builder.createdAt;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * Suite Run ID of the started suite run.
     * </p>
     * 
     * @return Suite Run ID of the started suite run.
     */
    public final String suiteRunId() {
        return suiteRunId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the started suite run.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the started suite run.
     */
    public final String suiteRunArn() {
        return suiteRunArn;
    }

    /**
     * <p>
     * Starts a Device Advisor test suite run based on suite create time.
     * </p>
     * 
     * @return Starts a Device Advisor test suite run based on suite create time.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The response of an Device Advisor test endpoint.
     * </p>
     * 
     * @return The response of an Device Advisor test endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSuiteRunResponse)) {
            return false;
        }
        StartSuiteRunResponse other = (StartSuiteRunResponse) obj;
        return Objects.equals(suiteRunId(), other.suiteRunId()) && Objects.equals(suiteRunArn(), other.suiteRunArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSuiteRunResponse").add("SuiteRunId", suiteRunId()).add("SuiteRunArn", suiteRunArn())
                .add("CreatedAt", createdAt()).add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteRunId":
            return Optional.ofNullable(clazz.cast(suiteRunId()));
        case "suiteRunArn":
            return Optional.ofNullable(clazz.cast(suiteRunArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteRunId", SUITE_RUN_ID_FIELD);
        map.put("suiteRunArn", SUITE_RUN_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSuiteRunResponse, T> g) {
        return obj -> g.apply((StartSuiteRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSuiteRunResponse> {
        /**
         * <p>
         * Suite Run ID of the started suite run.
         * </p>
         * 
         * @param suiteRunId
         *        Suite Run ID of the started suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunId(String suiteRunId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the started suite run.
         * </p>
         * 
         * @param suiteRunArn
         *        Amazon Resource Name (ARN) of the started suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunArn(String suiteRunArn);

        /**
         * <p>
         * Starts a Device Advisor test suite run based on suite create time.
         * </p>
         * 
         * @param createdAt
         *        Starts a Device Advisor test suite run based on suite create time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The response of an Device Advisor test endpoint.
         * </p>
         * 
         * @param endpoint
         *        The response of an Device Advisor test endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteRunId;

        private String suiteRunArn;

        private Instant createdAt;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSuiteRunResponse model) {
            super(model);
            suiteRunId(model.suiteRunId);
            suiteRunArn(model.suiteRunArn);
            createdAt(model.createdAt);
            endpoint(model.endpoint);
        }

        public final String getSuiteRunId() {
            return suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final String getSuiteRunArn() {
            return suiteRunArn;
        }

        public final void setSuiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
        }

        @Override
        public final Builder suiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public StartSuiteRunResponse build() {
            return new StartSuiteRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
