/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the suite definition configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuiteDefinitionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SuiteDefinitionConfiguration.Builder, SuiteDefinitionConfiguration> {
    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(SuiteDefinitionConfiguration::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<List<DeviceUnderTest>> DEVICES_FIELD = SdkField
            .<List<DeviceUnderTest>> builder(MarshallingType.LIST)
            .memberName("devices")
            .getter(getter(SuiteDefinitionConfiguration::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceUnderTest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceUnderTest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INTENDED_FOR_QUALIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("intendedForQualification").getter(getter(SuiteDefinitionConfiguration::intendedForQualification))
            .setter(setter(Builder::intendedForQualification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intendedForQualification").build())
            .build();

    private static final SdkField<Boolean> IS_LONG_DURATION_TEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLongDurationTest").getter(getter(SuiteDefinitionConfiguration::isLongDurationTest))
            .setter(setter(Builder::isLongDurationTest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLongDurationTest").build())
            .build();

    private static final SdkField<String> ROOT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootGroup").getter(getter(SuiteDefinitionConfiguration::rootGroup)).setter(setter(Builder::rootGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootGroup").build()).build();

    private static final SdkField<String> DEVICE_PERMISSION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("devicePermissionRoleArn").getter(getter(SuiteDefinitionConfiguration::devicePermissionRoleArn))
            .setter(setter(Builder::devicePermissionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePermissionRoleArn").build())
            .build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(SuiteDefinitionConfiguration::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_NAME_FIELD,
            DEVICES_FIELD, INTENDED_FOR_QUALIFICATION_FIELD, IS_LONG_DURATION_TEST_FIELD, ROOT_GROUP_FIELD,
            DEVICE_PERMISSION_ROLE_ARN_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String suiteDefinitionName;

    private final List<DeviceUnderTest> devices;

    private final Boolean intendedForQualification;

    private final Boolean isLongDurationTest;

    private final String rootGroup;

    private final String devicePermissionRoleArn;

    private final String protocol;

    private SuiteDefinitionConfiguration(BuilderImpl builder) {
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.devices = builder.devices;
        this.intendedForQualification = builder.intendedForQualification;
        this.isLongDurationTest = builder.isLongDurationTest;
        this.rootGroup = builder.rootGroup;
        this.devicePermissionRoleArn = builder.devicePermissionRoleArn;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * Gets the suite definition name. This is a required parameter.
     * </p>
     * 
     * @return Gets the suite definition name. This is a required parameter.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Devices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets the devices configured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevices} method.
     * </p>
     * 
     * @return Gets the devices configured.
     */
    public final List<DeviceUnderTest> devices() {
        return devices;
    }

    /**
     * <p>
     * Gets the tests intended for qualification in a suite.
     * </p>
     * 
     * @return Gets the tests intended for qualification in a suite.
     */
    public final Boolean intendedForQualification() {
        return intendedForQualification;
    }

    /**
     * <p>
     * Verifies if the test suite is a long duration test.
     * </p>
     * 
     * @return Verifies if the test suite is a long duration test.
     */
    public final Boolean isLongDurationTest() {
        return isLongDurationTest;
    }

    /**
     * <p>
     * Gets the test suite root group. This is a required parameter. For updating or creating the latest qualification
     * suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code> can be an empty string. If
     * <code>intendedForQualification</code> is false, <code>rootGroup</code> cannot be an empty string. If
     * <code>rootGroup</code> is empty, and <code>intendedForQualification</code> is set to true, all the qualification
     * tests are included, and the configuration is default.
     * </p>
     * <p>
     * For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite, the
     * minimum length is 1, and the maximum is 2048.
     * </p>
     * 
     * @return Gets the test suite root group. This is a required parameter. For updating or creating the latest
     *         qualification suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code> can
     *         be an empty string. If <code>intendedForQualification</code> is false, <code>rootGroup</code> cannot be
     *         an empty string. If <code>rootGroup</code> is empty, and <code>intendedForQualification</code> is set to
     *         true, all the qualification tests are included, and the configuration is default.</p>
     *         <p>
     *         For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification
     *         suite, the minimum length is 1, and the maximum is 2048.
     */
    public final String rootGroup() {
        return rootGroup;
    }

    /**
     * <p>
     * Gets the device permission ARN. This is a required parameter.
     * </p>
     * 
     * @return Gets the device permission ARN. This is a required parameter.
     */
    public final String devicePermissionRoleArn() {
        return devicePermissionRoleArn;
    }

    /**
     * <p>
     * Sets the MQTT protocol that is configured in the suite definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return Sets the MQTT protocol that is configured in the suite definition.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * Sets the MQTT protocol that is configured in the suite definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return Sets the MQTT protocol that is configured in the suite definition.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intendedForQualification());
        hashCode = 31 * hashCode + Objects.hashCode(isLongDurationTest());
        hashCode = 31 * hashCode + Objects.hashCode(rootGroup());
        hashCode = 31 * hashCode + Objects.hashCode(devicePermissionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionConfiguration)) {
            return false;
        }
        SuiteDefinitionConfiguration other = (SuiteDefinitionConfiguration) obj;
        return Objects.equals(suiteDefinitionName(), other.suiteDefinitionName()) && hasDevices() == other.hasDevices()
                && Objects.equals(devices(), other.devices())
                && Objects.equals(intendedForQualification(), other.intendedForQualification())
                && Objects.equals(isLongDurationTest(), other.isLongDurationTest())
                && Objects.equals(rootGroup(), other.rootGroup())
                && Objects.equals(devicePermissionRoleArn(), other.devicePermissionRoleArn())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuiteDefinitionConfiguration").add("SuiteDefinitionName", suiteDefinitionName())
                .add("Devices", hasDevices() ? devices() : null).add("IntendedForQualification", intendedForQualification())
                .add("IsLongDurationTest", isLongDurationTest()).add("RootGroup", rootGroup())
                .add("DevicePermissionRoleArn", devicePermissionRoleArn()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "intendedForQualification":
            return Optional.ofNullable(clazz.cast(intendedForQualification()));
        case "isLongDurationTest":
            return Optional.ofNullable(clazz.cast(isLongDurationTest()));
        case "rootGroup":
            return Optional.ofNullable(clazz.cast(rootGroup()));
        case "devicePermissionRoleArn":
            return Optional.ofNullable(clazz.cast(devicePermissionRoleArn()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionName", SUITE_DEFINITION_NAME_FIELD);
        map.put("devices", DEVICES_FIELD);
        map.put("intendedForQualification", INTENDED_FOR_QUALIFICATION_FIELD);
        map.put("isLongDurationTest", IS_LONG_DURATION_TEST_FIELD);
        map.put("rootGroup", ROOT_GROUP_FIELD);
        map.put("devicePermissionRoleArn", DEVICE_PERMISSION_ROLE_ARN_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuiteDefinitionConfiguration, T> g) {
        return obj -> g.apply((SuiteDefinitionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuiteDefinitionConfiguration> {
        /**
         * <p>
         * Gets the suite definition name. This is a required parameter.
         * </p>
         * 
         * @param suiteDefinitionName
         *        Gets the suite definition name. This is a required parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * 
         * @param devices
         *        Gets the devices configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceUnderTest> devices);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * 
         * @param devices
         *        Gets the devices configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceUnderTest... devices);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest.Builder#build()} is called
         * immediately and its result is passed to {@link #devices(List<DeviceUnderTest>)}.
         * 
         * @param devices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(java.util.Collection<DeviceUnderTest>)
         */
        Builder devices(Consumer<DeviceUnderTest.Builder>... devices);

        /**
         * <p>
         * Gets the tests intended for qualification in a suite.
         * </p>
         * 
         * @param intendedForQualification
         *        Gets the tests intended for qualification in a suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intendedForQualification(Boolean intendedForQualification);

        /**
         * <p>
         * Verifies if the test suite is a long duration test.
         * </p>
         * 
         * @param isLongDurationTest
         *        Verifies if the test suite is a long duration test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLongDurationTest(Boolean isLongDurationTest);

        /**
         * <p>
         * Gets the test suite root group. This is a required parameter. For updating or creating the latest
         * qualification suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code> can be
         * an empty string. If <code>intendedForQualification</code> is false, <code>rootGroup</code> cannot be an empty
         * string. If <code>rootGroup</code> is empty, and <code>intendedForQualification</code> is set to true, all the
         * qualification tests are included, and the configuration is default.
         * </p>
         * <p>
         * For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite,
         * the minimum length is 1, and the maximum is 2048.
         * </p>
         * 
         * @param rootGroup
         *        Gets the test suite root group. This is a required parameter. For updating or creating the latest
         *        qualification suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code>
         *        can be an empty string. If <code>intendedForQualification</code> is false, <code>rootGroup</code>
         *        cannot be an empty string. If <code>rootGroup</code> is empty, and
         *        <code>intendedForQualification</code> is set to true, all the qualification tests are included, and
         *        the configuration is default.</p>
         *        <p>
         *        For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification
         *        suite, the minimum length is 1, and the maximum is 2048.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootGroup(String rootGroup);

        /**
         * <p>
         * Gets the device permission ARN. This is a required parameter.
         * </p>
         * 
         * @param devicePermissionRoleArn
         *        Gets the device permission ARN. This is a required parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePermissionRoleArn(String devicePermissionRoleArn);

        /**
         * <p>
         * Sets the MQTT protocol that is configured in the suite definition.
         * </p>
         * 
         * @param protocol
         *        Sets the MQTT protocol that is configured in the suite definition.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Sets the MQTT protocol that is configured in the suite definition.
         * </p>
         * 
         * @param protocol
         *        Sets the MQTT protocol that is configured in the suite definition.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String suiteDefinitionName;

        private List<DeviceUnderTest> devices = DefaultSdkAutoConstructList.getInstance();

        private Boolean intendedForQualification;

        private Boolean isLongDurationTest;

        private String rootGroup;

        private String devicePermissionRoleArn;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteDefinitionConfiguration model) {
            suiteDefinitionName(model.suiteDefinitionName);
            devices(model.devices);
            intendedForQualification(model.intendedForQualification);
            isLongDurationTest(model.isLongDurationTest);
            rootGroup(model.rootGroup);
            devicePermissionRoleArn(model.devicePermissionRoleArn);
            protocol(model.protocol);
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final List<DeviceUnderTest.Builder> getDevices() {
            List<DeviceUnderTest.Builder> result = DeviceUnderTestListCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<DeviceUnderTest.BuilderImpl> devices) {
            this.devices = DeviceUnderTestListCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<DeviceUnderTest> devices) {
            this.devices = DeviceUnderTestListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceUnderTest... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceUnderTest.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceUnderTest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIntendedForQualification() {
            return intendedForQualification;
        }

        public final void setIntendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
        }

        @Override
        public final Builder intendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
            return this;
        }

        public final Boolean getIsLongDurationTest() {
            return isLongDurationTest;
        }

        public final void setIsLongDurationTest(Boolean isLongDurationTest) {
            this.isLongDurationTest = isLongDurationTest;
        }

        @Override
        public final Builder isLongDurationTest(Boolean isLongDurationTest) {
            this.isLongDurationTest = isLongDurationTest;
            return this;
        }

        public final String getRootGroup() {
            return rootGroup;
        }

        public final void setRootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
        }

        @Override
        public final Builder rootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
            return this;
        }

        public final String getDevicePermissionRoleArn() {
            return devicePermissionRoleArn;
        }

        public final void setDevicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
        }

        @Override
        public final Builder devicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public SuiteDefinitionConfiguration build() {
            return new SuiteDefinitionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
