/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the test case run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseRun implements SdkPojo, Serializable, ToCopyableBuilder<TestCaseRun.Builder, TestCaseRun> {
    private static final SdkField<String> TEST_CASE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseRunId").getter(getter(TestCaseRun::testCaseRunId)).setter(setter(Builder::testCaseRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseRunId").build()).build();

    private static final SdkField<String> TEST_CASE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseDefinitionId").getter(getter(TestCaseRun::testCaseDefinitionId))
            .setter(setter(Builder::testCaseDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionId").build())
            .build();

    private static final SdkField<String> TEST_CASE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseDefinitionName").getter(getter(TestCaseRun::testCaseDefinitionName))
            .setter(setter(Builder::testCaseDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseRun::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(TestCaseRun::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(TestCaseRun::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUrl")
            .getter(getter(TestCaseRun::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()).build();

    private static final SdkField<String> WARNINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warnings").getter(getter(TestCaseRun::warnings)).setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build()).build();

    private static final SdkField<String> FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("failure")
            .getter(getter(TestCaseRun::failure)).setter(setter(Builder::failure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()).build();

    private static final SdkField<List<TestCaseScenario>> TEST_SCENARIOS_FIELD = SdkField
            .<List<TestCaseScenario>> builder(MarshallingType.LIST)
            .memberName("testScenarios")
            .getter(getter(TestCaseRun::testScenarios))
            .setter(setter(Builder::testScenarios))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testScenarios").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCaseScenario> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCaseScenario::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_RUN_ID_FIELD,
            TEST_CASE_DEFINITION_ID_FIELD, TEST_CASE_DEFINITION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            LOG_URL_FIELD, WARNINGS_FIELD, FAILURE_FIELD, TEST_SCENARIOS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testCaseRunId;

    private final String testCaseDefinitionId;

    private final String testCaseDefinitionName;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String logUrl;

    private final String warnings;

    private final String failure;

    private final List<TestCaseScenario> testScenarios;

    private TestCaseRun(BuilderImpl builder) {
        this.testCaseRunId = builder.testCaseRunId;
        this.testCaseDefinitionId = builder.testCaseDefinitionId;
        this.testCaseDefinitionName = builder.testCaseDefinitionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.warnings = builder.warnings;
        this.failure = builder.failure;
        this.testScenarios = builder.testScenarios;
    }

    /**
     * <p>
     * Provides the test case run ID.
     * </p>
     * 
     * @return Provides the test case run ID.
     */
    public final String testCaseRunId() {
        return testCaseRunId;
    }

    /**
     * <p>
     * Provides the test case run definition ID.
     * </p>
     * 
     * @return Provides the test case run definition ID.
     */
    public final String testCaseDefinitionId() {
        return testCaseDefinitionId;
    }

    /**
     * <p>
     * Provides the test case run definition name.
     * </p>
     * 
     * @return Provides the test case run definition name.
     */
    public final String testCaseDefinitionName() {
        return testCaseDefinitionName;
    }

    /**
     * <p>
     * Provides the test case run status. Status is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASS</code>: Test passed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL</code>: Test failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Test has not started running but is scheduled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: Test is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERORR</code>: Test faced an error when running due to an internal issue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the test case run status. Status is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASS</code>: Test passed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: Test failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Test has not started running but is scheduled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: Test is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
     *         suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERORR</code>: Test faced an error when running due to an internal issue.
     *         </p>
     *         </li>
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Provides the test case run status. Status is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASS</code>: Test passed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL</code>: Test failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Test has not started running but is scheduled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: Test is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERORR</code>: Test faced an error when running due to an internal issue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the test case run status. Status is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASS</code>: Test passed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: Test failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Test has not started running but is scheduled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: Test is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
     *         suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERORR</code>: Test faced an error when running due to an internal issue.
     *         </p>
     *         </li>
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides test case run start time.
     * </p>
     * 
     * @return Provides test case run start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Provides test case run end time.
     * </p>
     * 
     * @return Provides test case run end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Provides test case run log URL.
     * </p>
     * 
     * @return Provides test case run log URL.
     */
    public final String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * Provides test case run warnings.
     * </p>
     * 
     * @return Provides test case run warnings.
     */
    public final String warnings() {
        return warnings;
    }

    /**
     * <p>
     * Provides test case run failure result.
     * </p>
     * 
     * @return Provides test case run failure result.
     */
    public final String failure() {
        return failure;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestScenarios property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestScenarios() {
        return testScenarios != null && !(testScenarios instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the test scenarios for the test case run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestScenarios} method.
     * </p>
     * 
     * @return Provides the test scenarios for the test case run.
     */
    public final List<TestCaseScenario> testScenarios() {
        return testScenarios;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseRunId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        hashCode = 31 * hashCode + Objects.hashCode(failure());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestScenarios() ? testScenarios() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseRun)) {
            return false;
        }
        TestCaseRun other = (TestCaseRun) obj;
        return Objects.equals(testCaseRunId(), other.testCaseRunId())
                && Objects.equals(testCaseDefinitionId(), other.testCaseDefinitionId())
                && Objects.equals(testCaseDefinitionName(), other.testCaseDefinitionName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(logUrl(), other.logUrl())
                && Objects.equals(warnings(), other.warnings()) && Objects.equals(failure(), other.failure())
                && hasTestScenarios() == other.hasTestScenarios() && Objects.equals(testScenarios(), other.testScenarios());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseRun").add("TestCaseRunId", testCaseRunId())
                .add("TestCaseDefinitionId", testCaseDefinitionId()).add("TestCaseDefinitionName", testCaseDefinitionName())
                .add("Status", statusAsString()).add("StartTime", startTime()).add("EndTime", endTime()).add("LogUrl", logUrl())
                .add("Warnings", warnings()).add("Failure", failure())
                .add("TestScenarios", hasTestScenarios() ? testScenarios() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseRunId":
            return Optional.ofNullable(clazz.cast(testCaseRunId()));
        case "testCaseDefinitionId":
            return Optional.ofNullable(clazz.cast(testCaseDefinitionId()));
        case "testCaseDefinitionName":
            return Optional.ofNullable(clazz.cast(testCaseDefinitionName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "logUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "failure":
            return Optional.ofNullable(clazz.cast(failure()));
        case "testScenarios":
            return Optional.ofNullable(clazz.cast(testScenarios()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseRunId", TEST_CASE_RUN_ID_FIELD);
        map.put("testCaseDefinitionId", TEST_CASE_DEFINITION_ID_FIELD);
        map.put("testCaseDefinitionName", TEST_CASE_DEFINITION_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("logUrl", LOG_URL_FIELD);
        map.put("warnings", WARNINGS_FIELD);
        map.put("failure", FAILURE_FIELD);
        map.put("testScenarios", TEST_SCENARIOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseRun, T> g) {
        return obj -> g.apply((TestCaseRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseRun> {
        /**
         * <p>
         * Provides the test case run ID.
         * </p>
         * 
         * @param testCaseRunId
         *        Provides the test case run ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseRunId(String testCaseRunId);

        /**
         * <p>
         * Provides the test case run definition ID.
         * </p>
         * 
         * @param testCaseDefinitionId
         *        Provides the test case run definition ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseDefinitionId(String testCaseDefinitionId);

        /**
         * <p>
         * Provides the test case run definition name.
         * </p>
         * 
         * @param testCaseDefinitionName
         *        Provides the test case run definition name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseDefinitionName(String testCaseDefinitionName);

        /**
         * <p>
         * Provides the test case run status. Status is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASS</code>: Test passed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL</code>: Test failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Test has not started running but is scheduled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: Test is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERORR</code>: Test faced an error when running due to an internal issue.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Provides the test case run status. Status is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASS</code>: Test passed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: Test failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Test has not started running but is scheduled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: Test is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
         *        suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERORR</code>: Test faced an error when running due to an internal issue.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Provides the test case run status. Status is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASS</code>: Test passed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL</code>: Test failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Test has not started running but is scheduled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: Test is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERORR</code>: Test faced an error when running due to an internal issue.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Provides the test case run status. Status is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASS</code>: Test passed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: Test failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Test has not started running but is scheduled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: Test is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
         *        suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERORR</code>: Test faced an error when running due to an internal issue.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Provides test case run start time.
         * </p>
         * 
         * @param startTime
         *        Provides test case run start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Provides test case run end time.
         * </p>
         * 
         * @param endTime
         *        Provides test case run end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Provides test case run log URL.
         * </p>
         * 
         * @param logUrl
         *        Provides test case run log URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * Provides test case run warnings.
         * </p>
         * 
         * @param warnings
         *        Provides test case run warnings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String warnings);

        /**
         * <p>
         * Provides test case run failure result.
         * </p>
         * 
         * @param failure
         *        Provides test case run failure result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failure(String failure);

        /**
         * <p>
         * Provides the test scenarios for the test case run.
         * </p>
         * 
         * @param testScenarios
         *        Provides the test scenarios for the test case run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testScenarios(Collection<TestCaseScenario> testScenarios);

        /**
         * <p>
         * Provides the test scenarios for the test case run.
         * </p>
         * 
         * @param testScenarios
         *        Provides the test scenarios for the test case run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testScenarios(TestCaseScenario... testScenarios);

        /**
         * <p>
         * Provides the test scenarios for the test case run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #testScenarios(List<TestCaseScenario>)}.
         * 
         * @param testScenarios
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testScenarios(java.util.Collection<TestCaseScenario>)
         */
        Builder testScenarios(Consumer<TestCaseScenario.Builder>... testScenarios);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseRunId;

        private String testCaseDefinitionId;

        private String testCaseDefinitionName;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String logUrl;

        private String warnings;

        private String failure;

        private List<TestCaseScenario> testScenarios = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseRun model) {
            testCaseRunId(model.testCaseRunId);
            testCaseDefinitionId(model.testCaseDefinitionId);
            testCaseDefinitionName(model.testCaseDefinitionName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            logUrl(model.logUrl);
            warnings(model.warnings);
            failure(model.failure);
            testScenarios(model.testScenarios);
        }

        public final String getTestCaseRunId() {
            return testCaseRunId;
        }

        public final void setTestCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
        }

        @Override
        public final Builder testCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
            return this;
        }

        public final String getTestCaseDefinitionId() {
            return testCaseDefinitionId;
        }

        public final void setTestCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
        }

        @Override
        public final Builder testCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
            return this;
        }

        public final String getTestCaseDefinitionName() {
            return testCaseDefinitionName;
        }

        public final void setTestCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
        }

        @Override
        public final Builder testCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final String getWarnings() {
            return warnings;
        }

        public final void setWarnings(String warnings) {
            this.warnings = warnings;
        }

        @Override
        public final Builder warnings(String warnings) {
            this.warnings = warnings;
            return this;
        }

        public final String getFailure() {
            return failure;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        public final List<TestCaseScenario.Builder> getTestScenarios() {
            List<TestCaseScenario.Builder> result = TestCaseScenariosListCopier.copyToBuilder(this.testScenarios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestScenarios(Collection<TestCaseScenario.BuilderImpl> testScenarios) {
            this.testScenarios = TestCaseScenariosListCopier.copyFromBuilder(testScenarios);
        }

        @Override
        public final Builder testScenarios(Collection<TestCaseScenario> testScenarios) {
            this.testScenarios = TestCaseScenariosListCopier.copy(testScenarios);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testScenarios(TestCaseScenario... testScenarios) {
            testScenarios(Arrays.asList(testScenarios));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testScenarios(Consumer<TestCaseScenario.Builder>... testScenarios) {
            testScenarios(Stream.of(testScenarios).map(c -> TestCaseScenario.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestCaseRun build() {
            return new TestCaseRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
