/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides test case scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseScenario implements SdkPojo, Serializable,
        ToCopyableBuilder<TestCaseScenario.Builder, TestCaseScenario> {
    private static final SdkField<String> TEST_CASE_SCENARIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseScenarioId").getter(getter(TestCaseScenario::testCaseScenarioId))
            .setter(setter(Builder::testCaseScenarioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseScenarioId").build())
            .build();

    private static final SdkField<String> TEST_CASE_SCENARIO_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseScenarioType").getter(getter(TestCaseScenario::testCaseScenarioTypeAsString))
            .setter(setter(Builder::testCaseScenarioType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseScenarioType").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseScenario::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("failure")
            .getter(getter(TestCaseScenario::failure)).setter(setter(Builder::failure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessage").getter(getter(TestCaseScenario::systemMessage)).setter(setter(Builder::systemMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_SCENARIO_ID_FIELD,
            TEST_CASE_SCENARIO_TYPE_FIELD, STATUS_FIELD, FAILURE_FIELD, SYSTEM_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testCaseScenarioId;

    private final String testCaseScenarioType;

    private final String status;

    private final String failure;

    private final String systemMessage;

    private TestCaseScenario(BuilderImpl builder) {
        this.testCaseScenarioId = builder.testCaseScenarioId;
        this.testCaseScenarioType = builder.testCaseScenarioType;
        this.status = builder.status;
        this.failure = builder.failure;
        this.systemMessage = builder.systemMessage;
    }

    /**
     * <p>
     * Provides test case scenario ID.
     * </p>
     * 
     * @return Provides test case scenario ID.
     */
    public final String testCaseScenarioId() {
        return testCaseScenarioId;
    }

    /**
     * <p>
     * Provides test case scenario type. Type is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Advanced
     * </p>
     * </li>
     * <li>
     * <p>
     * Basic
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testCaseScenarioType} will return {@link TestCaseScenarioType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testCaseScenarioTypeAsString}.
     * </p>
     * 
     * @return Provides test case scenario type. Type is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Advanced
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Basic
     *         </p>
     *         </li>
     * @see TestCaseScenarioType
     */
    public final TestCaseScenarioType testCaseScenarioType() {
        return TestCaseScenarioType.fromValue(testCaseScenarioType);
    }

    /**
     * <p>
     * Provides test case scenario type. Type is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Advanced
     * </p>
     * </li>
     * <li>
     * <p>
     * Basic
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testCaseScenarioType} will return {@link TestCaseScenarioType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testCaseScenarioTypeAsString}.
     * </p>
     * 
     * @return Provides test case scenario type. Type is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Advanced
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Basic
     *         </p>
     *         </li>
     * @see TestCaseScenarioType
     */
    public final String testCaseScenarioTypeAsString() {
        return testCaseScenarioType;
    }

    /**
     * <p>
     * Provides the test case scenario status. Status is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASS</code>: Test passed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL</code>: Test failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Test has not started running but is scheduled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: Test is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERORR</code>: Test faced an error when running due to an internal issue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseScenarioStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the test case scenario status. Status is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASS</code>: Test passed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: Test failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Test has not started running but is scheduled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: Test is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
     *         suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERORR</code>: Test faced an error when running due to an internal issue.
     *         </p>
     *         </li>
     * @see TestCaseScenarioStatus
     */
    public final TestCaseScenarioStatus status() {
        return TestCaseScenarioStatus.fromValue(status);
    }

    /**
     * <p>
     * Provides the test case scenario status. Status is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASS</code>: Test passed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL</code>: Test failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Test has not started running but is scheduled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: Test is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERORR</code>: Test faced an error when running due to an internal issue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseScenarioStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the test case scenario status. Status is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASS</code>: Test passed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: Test failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Test has not started running but is scheduled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: Test is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
     *         suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERORR</code>: Test faced an error when running due to an internal issue.
     *         </p>
     *         </li>
     * @see TestCaseScenarioStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides test case scenario failure result.
     * </p>
     * 
     * @return Provides test case scenario failure result.
     */
    public final String failure() {
        return failure;
    }

    /**
     * <p>
     * Provides test case scenario system messages if any.
     * </p>
     * 
     * @return Provides test case scenario system messages if any.
     */
    public final String systemMessage() {
        return systemMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseScenarioTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failure());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseScenario)) {
            return false;
        }
        TestCaseScenario other = (TestCaseScenario) obj;
        return Objects.equals(testCaseScenarioId(), other.testCaseScenarioId())
                && Objects.equals(testCaseScenarioTypeAsString(), other.testCaseScenarioTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(failure(), other.failure())
                && Objects.equals(systemMessage(), other.systemMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseScenario").add("TestCaseScenarioId", testCaseScenarioId())
                .add("TestCaseScenarioType", testCaseScenarioTypeAsString()).add("Status", statusAsString())
                .add("Failure", failure()).add("SystemMessage", systemMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseScenarioId":
            return Optional.ofNullable(clazz.cast(testCaseScenarioId()));
        case "testCaseScenarioType":
            return Optional.ofNullable(clazz.cast(testCaseScenarioTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failure":
            return Optional.ofNullable(clazz.cast(failure()));
        case "systemMessage":
            return Optional.ofNullable(clazz.cast(systemMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseScenarioId", TEST_CASE_SCENARIO_ID_FIELD);
        map.put("testCaseScenarioType", TEST_CASE_SCENARIO_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failure", FAILURE_FIELD);
        map.put("systemMessage", SYSTEM_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseScenario, T> g) {
        return obj -> g.apply((TestCaseScenario) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseScenario> {
        /**
         * <p>
         * Provides test case scenario ID.
         * </p>
         * 
         * @param testCaseScenarioId
         *        Provides test case scenario ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseScenarioId(String testCaseScenarioId);

        /**
         * <p>
         * Provides test case scenario type. Type is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Advanced
         * </p>
         * </li>
         * <li>
         * <p>
         * Basic
         * </p>
         * </li>
         * </ul>
         * 
         * @param testCaseScenarioType
         *        Provides test case scenario type. Type is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Advanced
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Basic
         *        </p>
         *        </li>
         * @see TestCaseScenarioType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseScenarioType
         */
        Builder testCaseScenarioType(String testCaseScenarioType);

        /**
         * <p>
         * Provides test case scenario type. Type is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Advanced
         * </p>
         * </li>
         * <li>
         * <p>
         * Basic
         * </p>
         * </li>
         * </ul>
         * 
         * @param testCaseScenarioType
         *        Provides test case scenario type. Type is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Advanced
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Basic
         *        </p>
         *        </li>
         * @see TestCaseScenarioType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseScenarioType
         */
        Builder testCaseScenarioType(TestCaseScenarioType testCaseScenarioType);

        /**
         * <p>
         * Provides the test case scenario status. Status is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASS</code>: Test passed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL</code>: Test failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Test has not started running but is scheduled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: Test is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERORR</code>: Test faced an error when running due to an internal issue.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Provides the test case scenario status. Status is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASS</code>: Test passed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: Test failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Test has not started running but is scheduled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: Test is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
         *        suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERORR</code>: Test faced an error when running due to an internal issue.
         *        </p>
         *        </li>
         * @see TestCaseScenarioStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseScenarioStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Provides the test case scenario status. Status is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASS</code>: Test passed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL</code>: Test failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Test has not started running but is scheduled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: Test is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERORR</code>: Test faced an error when running due to an internal issue.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Provides the test case scenario status. Status is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASS</code>: Test passed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: Test failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Test has not started running but is scheduled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: Test is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a
         *        suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERORR</code>: Test faced an error when running due to an internal issue.
         *        </p>
         *        </li>
         * @see TestCaseScenarioStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseScenarioStatus
         */
        Builder status(TestCaseScenarioStatus status);

        /**
         * <p>
         * Provides test case scenario failure result.
         * </p>
         * 
         * @param failure
         *        Provides test case scenario failure result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failure(String failure);

        /**
         * <p>
         * Provides test case scenario system messages if any.
         * </p>
         * 
         * @param systemMessage
         *        Provides test case scenario system messages if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessage(String systemMessage);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseScenarioId;

        private String testCaseScenarioType;

        private String status;

        private String failure;

        private String systemMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseScenario model) {
            testCaseScenarioId(model.testCaseScenarioId);
            testCaseScenarioType(model.testCaseScenarioType);
            status(model.status);
            failure(model.failure);
            systemMessage(model.systemMessage);
        }

        public final String getTestCaseScenarioId() {
            return testCaseScenarioId;
        }

        public final void setTestCaseScenarioId(String testCaseScenarioId) {
            this.testCaseScenarioId = testCaseScenarioId;
        }

        @Override
        public final Builder testCaseScenarioId(String testCaseScenarioId) {
            this.testCaseScenarioId = testCaseScenarioId;
            return this;
        }

        public final String getTestCaseScenarioType() {
            return testCaseScenarioType;
        }

        public final void setTestCaseScenarioType(String testCaseScenarioType) {
            this.testCaseScenarioType = testCaseScenarioType;
        }

        @Override
        public final Builder testCaseScenarioType(String testCaseScenarioType) {
            this.testCaseScenarioType = testCaseScenarioType;
            return this;
        }

        @Override
        public final Builder testCaseScenarioType(TestCaseScenarioType testCaseScenarioType) {
            this.testCaseScenarioType(testCaseScenarioType == null ? null : testCaseScenarioType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseScenarioStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailure() {
            return failure;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        public final String getSystemMessage() {
            return systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        @Override
        public TestCaseScenario build() {
            return new TestCaseScenario(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
