/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSuiteDefinitionResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<UpdateSuiteDefinitionResponse.Builder, UpdateSuiteDefinitionResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(UpdateSuiteDefinitionResponse::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionArn").getter(getter(UpdateSuiteDefinitionResponse::suiteDefinitionArn))
            .setter(setter(Builder::suiteDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionArn").build())
            .build();

    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(UpdateSuiteDefinitionResponse::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion").getter(getter(UpdateSuiteDefinitionResponse::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(UpdateSuiteDefinitionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(UpdateSuiteDefinitionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_ARN_FIELD, SUITE_DEFINITION_NAME_FIELD, SUITE_DEFINITION_VERSION_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String suiteDefinitionId;

    private final String suiteDefinitionArn;

    private final String suiteDefinitionName;

    private final String suiteDefinitionVersion;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private UpdateSuiteDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionArn = builder.suiteDefinitionArn;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * Suite definition ID of the updated test suite.
     * </p>
     * 
     * @return Suite definition ID of the updated test suite.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the updated test suite.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the updated test suite.
     */
    public final String suiteDefinitionArn() {
        return suiteDefinitionArn;
    }

    /**
     * <p>
     * Updates the suite definition name. This is a required parameter.
     * </p>
     * 
     * @return Updates the suite definition name. This is a required parameter.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * <p>
     * Suite definition version of the updated test suite.
     * </p>
     * 
     * @return Suite definition version of the updated test suite.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    /**
     * <p>
     * Timestamp of when the test suite was created.
     * </p>
     * 
     * @return Timestamp of when the test suite was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Timestamp of when the test suite was updated.
     * </p>
     * 
     * @return Timestamp of when the test suite was updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSuiteDefinitionResponse)) {
            return false;
        }
        UpdateSuiteDefinitionResponse other = (UpdateSuiteDefinitionResponse) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionArn(), other.suiteDefinitionArn())
                && Objects.equals(suiteDefinitionName(), other.suiteDefinitionName())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSuiteDefinitionResponse").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionArn", suiteDefinitionArn()).add("SuiteDefinitionName", suiteDefinitionName())
                .add("SuiteDefinitionVersion", suiteDefinitionVersion()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionArn":
            return Optional.ofNullable(clazz.cast(suiteDefinitionArn()));
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteDefinitionArn", SUITE_DEFINITION_ARN_FIELD);
        map.put("suiteDefinitionName", SUITE_DEFINITION_NAME_FIELD);
        map.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSuiteDefinitionResponse, T> g) {
        return obj -> g.apply((UpdateSuiteDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSuiteDefinitionResponse> {
        /**
         * <p>
         * Suite definition ID of the updated test suite.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the updated test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the updated test suite.
         * </p>
         * 
         * @param suiteDefinitionArn
         *        Amazon Resource Name (ARN) of the updated test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionArn(String suiteDefinitionArn);

        /**
         * <p>
         * Updates the suite definition name. This is a required parameter.
         * </p>
         * 
         * @param suiteDefinitionName
         *        Updates the suite definition name. This is a required parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * Suite definition version of the updated test suite.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version of the updated test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        /**
         * <p>
         * Timestamp of when the test suite was created.
         * </p>
         * 
         * @param createdAt
         *        Timestamp of when the test suite was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Timestamp of when the test suite was updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Timestamp of when the test suite was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionArn;

        private String suiteDefinitionName;

        private String suiteDefinitionVersion;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSuiteDefinitionResponse model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionArn(model.suiteDefinitionArn);
            suiteDefinitionName(model.suiteDefinitionName);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionArn() {
            return suiteDefinitionArn;
        }

        public final void setSuiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
        }

        @Override
        public final Builder suiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public UpdateSuiteDefinitionResponse build() {
            return new UpdateSuiteDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
