/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSuiteDefinitionRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<CreateSuiteDefinitionRequest.Builder, CreateSuiteDefinitionRequest> {
    private static final SdkField<SuiteDefinitionConfiguration> SUITE_DEFINITION_CONFIGURATION_FIELD = SdkField
            .<SuiteDefinitionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("suiteDefinitionConfiguration")
            .getter(getter(CreateSuiteDefinitionRequest::suiteDefinitionConfiguration))
            .setter(setter(Builder::suiteDefinitionConfiguration))
            .constructor(SuiteDefinitionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSuiteDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSuiteDefinitionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUITE_DEFINITION_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SuiteDefinitionConfiguration suiteDefinitionConfiguration;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateSuiteDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionConfiguration = builder.suiteDefinitionConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Creates a Device Advisor test suite with suite definition configuration.
     * </p>
     * 
     * @return Creates a Device Advisor test suite with suite definition configuration.
     */
    public final SuiteDefinitionConfiguration suiteDefinitionConfiguration() {
        return suiteDefinitionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be attached to the suite definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be attached to the suite definition.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The client token for the test suite definition creation. This token is used for tracking test suite definition
     * creation using retries and obtaining its status. This parameter is optional.
     * </p>
     * 
     * @return The client token for the test suite definition creation. This token is used for tracking test suite
     *         definition creation using retries and obtaining its status. This parameter is optional.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSuiteDefinitionRequest)) {
            return false;
        }
        CreateSuiteDefinitionRequest other = (CreateSuiteDefinitionRequest) obj;
        return Objects.equals(suiteDefinitionConfiguration(), other.suiteDefinitionConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSuiteDefinitionRequest")
                .add("SuiteDefinitionConfiguration", suiteDefinitionConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionConfiguration":
            return Optional.ofNullable(clazz.cast(suiteDefinitionConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionConfiguration", SUITE_DEFINITION_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSuiteDefinitionRequest, T> g) {
        return obj -> g.apply((CreateSuiteDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSuiteDefinitionRequest> {
        /**
         * <p>
         * Creates a Device Advisor test suite with suite definition configuration.
         * </p>
         * 
         * @param suiteDefinitionConfiguration
         *        Creates a Device Advisor test suite with suite definition configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration);

        /**
         * <p>
         * Creates a Device Advisor test suite with suite definition configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuiteDefinitionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SuiteDefinitionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuiteDefinitionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)}.
         * 
         * @param suiteDefinitionConfiguration
         *        a consumer that will call methods on {@link SuiteDefinitionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)
         */
        default Builder suiteDefinitionConfiguration(Consumer<SuiteDefinitionConfiguration.Builder> suiteDefinitionConfiguration) {
            return suiteDefinitionConfiguration(SuiteDefinitionConfiguration.builder()
                    .applyMutation(suiteDefinitionConfiguration).build());
        }

        /**
         * <p>
         * The tags to be attached to the suite definition.
         * </p>
         * 
         * @param tags
         *        The tags to be attached to the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The client token for the test suite definition creation. This token is used for tracking test suite
         * definition creation using retries and obtaining its status. This parameter is optional.
         * </p>
         * 
         * @param clientToken
         *        The client token for the test suite definition creation. This token is used for tracking test suite
         *        definition creation using retries and obtaining its status. This parameter is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private SuiteDefinitionConfiguration suiteDefinitionConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSuiteDefinitionRequest model) {
            super(model);
            suiteDefinitionConfiguration(model.suiteDefinitionConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final SuiteDefinitionConfiguration.Builder getSuiteDefinitionConfiguration() {
            return suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.toBuilder() : null;
        }

        public final void setSuiteDefinitionConfiguration(SuiteDefinitionConfiguration.BuilderImpl suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSuiteDefinitionRequest build() {
            return new CreateSuiteDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
