/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuiteRunReportRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<GetSuiteRunReportRequest.Builder, GetSuiteRunReportRequest> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(GetSuiteRunReportRequest::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunId").getter(getter(GetSuiteRunReportRequest::suiteRunId)).setter(setter(Builder::suiteRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteRunId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_RUN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String suiteDefinitionId;

    private final String suiteRunId;

    private GetSuiteRunReportRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteRunId = builder.suiteRunId;
    }

    /**
     * <p>
     * Suite definition ID of the test suite.
     * </p>
     * 
     * @return Suite definition ID of the test suite.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite run ID of the test suite run.
     * </p>
     * 
     * @return Suite run ID of the test suite run.
     */
    public final String suiteRunId() {
        return suiteRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteRunReportRequest)) {
            return false;
        }
        GetSuiteRunReportRequest other = (GetSuiteRunReportRequest) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(suiteRunId(), other.suiteRunId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuiteRunReportRequest").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteRunId", suiteRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteRunId":
            return Optional.ofNullable(clazz.cast(suiteRunId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteRunId", SUITE_RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteRunReportRequest, T> g) {
        return obj -> g.apply((GetSuiteRunReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSuiteRunReportRequest> {
        /**
         * <p>
         * Suite definition ID of the test suite.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite run ID of the test suite run.
         * </p>
         * 
         * @param suiteRunId
         *        Suite run ID of the test suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunId(String suiteRunId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteRunReportRequest model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteRunId(model.suiteRunId);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteRunId() {
            return suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSuiteRunReportRequest build() {
            return new GetSuiteRunReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
