/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the suite run.
 * </p>
 * <p>
 * Requires permission to access the <a href=
 * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
 * >SuiteRunInformation</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuiteRunInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SuiteRunInformation.Builder, SuiteRunInformation> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(SuiteRunInformation::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionVersion").getter(getter(SuiteRunInformation::suiteDefinitionVersion))
            .setter(setter(Builder::suiteDefinitionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build())
            .build();

    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(SuiteRunInformation::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteRunId").getter(getter(SuiteRunInformation::suiteRunId)).setter(setter(Builder::suiteRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SuiteRunInformation::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(SuiteRunInformation::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> END_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("endAt")
            .getter(getter(SuiteRunInformation::endAt)).setter(setter(Builder::endAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SuiteRunInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> PASSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("passed").getter(getter(SuiteRunInformation::passed)).setter(setter(Builder::passed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passed").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(SuiteRunInformation::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_VERSION_FIELD, SUITE_DEFINITION_NAME_FIELD, SUITE_RUN_ID_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD,
            END_AT_FIELD, STATUS_FIELD, PASSED_FIELD, FAILED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String suiteDefinitionId;

    private final String suiteDefinitionVersion;

    private final String suiteDefinitionName;

    private final String suiteRunId;

    private final Instant createdAt;

    private final Instant startedAt;

    private final Instant endAt;

    private final String status;

    private final Integer passed;

    private final Integer failed;

    private SuiteRunInformation(BuilderImpl builder) {
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.suiteRunId = builder.suiteRunId;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.endAt = builder.endAt;
        this.status = builder.status;
        this.passed = builder.passed;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * Suite definition ID of the suite run.
     * </p>
     * 
     * @return Suite definition ID of the suite run.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * Suite definition version of the suite run.
     * </p>
     * 
     * @return Suite definition version of the suite run.
     */
    public final String suiteDefinitionVersion() {
        return suiteDefinitionVersion;
    }

    /**
     * <p>
     * Suite definition name of the suite run.
     * </p>
     * 
     * @return Suite definition name of the suite run.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * <p>
     * Suite run ID of the suite run.
     * </p>
     * 
     * @return Suite run ID of the suite run.
     */
    public final String suiteRunId() {
        return suiteRunId;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite run was created.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite run was started.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite run was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * Date (in Unix epoch time) when the suite run ended.
     * </p>
     * 
     * @return Date (in Unix epoch time) when the suite run ended.
     */
    public final Instant endAt() {
        return endAt;
    }

    /**
     * <p>
     * Status of the suite run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SuiteRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the suite run.
     * @see SuiteRunStatus
     */
    public final SuiteRunStatus status() {
        return SuiteRunStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the suite run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SuiteRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the suite run.
     * @see SuiteRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Number of test cases that passed in the suite run.
     * </p>
     * 
     * @return Number of test cases that passed in the suite run.
     */
    public final Integer passed() {
        return passed;
    }

    /**
     * <p>
     * Number of test cases that failed in the suite run.
     * </p>
     * 
     * @return Number of test cases that failed in the suite run.
     */
    public final Integer failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunInformation)) {
            return false;
        }
        SuiteRunInformation other = (SuiteRunInformation) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionVersion(), other.suiteDefinitionVersion())
                && Objects.equals(suiteDefinitionName(), other.suiteDefinitionName())
                && Objects.equals(suiteRunId(), other.suiteRunId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endAt(), other.endAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(passed(), other.passed())
                && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuiteRunInformation").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionVersion", suiteDefinitionVersion()).add("SuiteDefinitionName", suiteDefinitionName())
                .add("SuiteRunId", suiteRunId()).add("CreatedAt", createdAt()).add("StartedAt", startedAt())
                .add("EndAt", endAt()).add("Status", statusAsString()).add("Passed", passed()).add("Failed", failed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionVersion":
            return Optional.ofNullable(clazz.cast(suiteDefinitionVersion()));
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "suiteRunId":
            return Optional.ofNullable(clazz.cast(suiteRunId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endAt":
            return Optional.ofNullable(clazz.cast(endAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "passed":
            return Optional.ofNullable(clazz.cast(passed()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
        map.put("suiteDefinitionName", SUITE_DEFINITION_NAME_FIELD);
        map.put("suiteRunId", SUITE_RUN_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endAt", END_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("passed", PASSED_FIELD);
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuiteRunInformation, T> g) {
        return obj -> g.apply((SuiteRunInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuiteRunInformation> {
        /**
         * <p>
         * Suite definition ID of the suite run.
         * </p>
         * 
         * @param suiteDefinitionId
         *        Suite definition ID of the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * Suite definition version of the suite run.
         * </p>
         * 
         * @param suiteDefinitionVersion
         *        Suite definition version of the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionVersion(String suiteDefinitionVersion);

        /**
         * <p>
         * Suite definition name of the suite run.
         * </p>
         * 
         * @param suiteDefinitionName
         *        Suite definition name of the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * Suite run ID of the suite run.
         * </p>
         * 
         * @param suiteRunId
         *        Suite run ID of the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteRunId(String suiteRunId);

        /**
         * <p>
         * Date (in Unix epoch time) when the suite run was created.
         * </p>
         * 
         * @param createdAt
         *        Date (in Unix epoch time) when the suite run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Date (in Unix epoch time) when the suite run was started.
         * </p>
         * 
         * @param startedAt
         *        Date (in Unix epoch time) when the suite run was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * Date (in Unix epoch time) when the suite run ended.
         * </p>
         * 
         * @param endAt
         *        Date (in Unix epoch time) when the suite run ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endAt(Instant endAt);

        /**
         * <p>
         * Status of the suite run.
         * </p>
         * 
         * @param status
         *        Status of the suite run.
         * @see SuiteRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuiteRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the suite run.
         * </p>
         * 
         * @param status
         *        Status of the suite run.
         * @see SuiteRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuiteRunStatus
         */
        Builder status(SuiteRunStatus status);

        /**
         * <p>
         * Number of test cases that passed in the suite run.
         * </p>
         * 
         * @param passed
         *        Number of test cases that passed in the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * Number of test cases that failed in the suite run.
         * </p>
         * 
         * @param failed
         *        Number of test cases that failed in the suite run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);
    }

    static final class BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionVersion;

        private String suiteDefinitionName;

        private String suiteRunId;

        private Instant createdAt;

        private Instant startedAt;

        private Instant endAt;

        private String status;

        private Integer passed;

        private Integer failed;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteRunInformation model) {
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionVersion(model.suiteDefinitionVersion);
            suiteDefinitionName(model.suiteDefinitionName);
            suiteRunId(model.suiteRunId);
            createdAt(model.createdAt);
            startedAt(model.startedAt);
            endAt(model.endAt);
            status(model.status);
            passed(model.passed);
            failed(model.failed);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final String getSuiteRunId() {
            return suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndAt() {
            return endAt;
        }

        public final void setEndAt(Instant endAt) {
            this.endAt = endAt;
        }

        @Override
        public final Builder endAt(Instant endAt) {
            this.endAt = endAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SuiteRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPassed() {
            return passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        @Override
        public SuiteRunInformation build() {
            return new SuiteRunInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
