/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.aws.greengrass.GreengrassCoreIPC;
import software.amazon.awssdk.aws.greengrass.GreengrassCoreIPCClient;
import software.amazon.awssdk.aws.greengrass.SubscribeToCertificateUpdatesResponseHandler;
import software.amazon.awssdk.aws.greengrass.SubscribeToComponentUpdatesResponseHandler;
import software.amazon.awssdk.aws.greengrass.SubscribeToConfigurationUpdateResponseHandler;
import software.amazon.awssdk.aws.greengrass.SubscribeToIoTCoreResponseHandler;
import software.amazon.awssdk.aws.greengrass.SubscribeToTopicResponseHandler;
import software.amazon.awssdk.aws.greengrass.SubscribeToValidateConfigurationUpdatesResponseHandler;
import software.amazon.awssdk.aws.greengrass.model.AuthorizeClientDeviceActionRequest;
import software.amazon.awssdk.aws.greengrass.model.AuthorizeClientDeviceActionResponse;
import software.amazon.awssdk.aws.greengrass.model.CertificateUpdateEvent;
import software.amazon.awssdk.aws.greengrass.model.ComponentUpdatePolicyEvents;
import software.amazon.awssdk.aws.greengrass.model.ConfigurationUpdateEvents;
import software.amazon.awssdk.aws.greengrass.model.CreateDebugPasswordRequest;
import software.amazon.awssdk.aws.greengrass.model.CreateDebugPasswordResponse;
import software.amazon.awssdk.aws.greengrass.model.CreateLocalDeploymentRequest;
import software.amazon.awssdk.aws.greengrass.model.CreateLocalDeploymentResponse;
import software.amazon.awssdk.aws.greengrass.model.DeferComponentUpdateRequest;
import software.amazon.awssdk.aws.greengrass.model.DeferComponentUpdateResponse;
import software.amazon.awssdk.aws.greengrass.model.DeleteThingShadowRequest;
import software.amazon.awssdk.aws.greengrass.model.DeleteThingShadowResponse;
import software.amazon.awssdk.aws.greengrass.model.GetClientDeviceAuthTokenRequest;
import software.amazon.awssdk.aws.greengrass.model.GetClientDeviceAuthTokenResponse;
import software.amazon.awssdk.aws.greengrass.model.GetComponentDetailsRequest;
import software.amazon.awssdk.aws.greengrass.model.GetComponentDetailsResponse;
import software.amazon.awssdk.aws.greengrass.model.GetConfigurationRequest;
import software.amazon.awssdk.aws.greengrass.model.GetConfigurationResponse;
import software.amazon.awssdk.aws.greengrass.model.GetLocalDeploymentStatusRequest;
import software.amazon.awssdk.aws.greengrass.model.GetLocalDeploymentStatusResponse;
import software.amazon.awssdk.aws.greengrass.model.GetSecretValueRequest;
import software.amazon.awssdk.aws.greengrass.model.GetSecretValueResponse;
import software.amazon.awssdk.aws.greengrass.model.GetThingShadowRequest;
import software.amazon.awssdk.aws.greengrass.model.GetThingShadowResponse;
import software.amazon.awssdk.aws.greengrass.model.IoTCoreMessage;
import software.amazon.awssdk.aws.greengrass.model.ListComponentsRequest;
import software.amazon.awssdk.aws.greengrass.model.ListComponentsResponse;
import software.amazon.awssdk.aws.greengrass.model.ListLocalDeploymentsRequest;
import software.amazon.awssdk.aws.greengrass.model.ListLocalDeploymentsResponse;
import software.amazon.awssdk.aws.greengrass.model.ListNamedShadowsForThingRequest;
import software.amazon.awssdk.aws.greengrass.model.ListNamedShadowsForThingResponse;
import software.amazon.awssdk.aws.greengrass.model.PauseComponentRequest;
import software.amazon.awssdk.aws.greengrass.model.PauseComponentResponse;
import software.amazon.awssdk.aws.greengrass.model.PublishToIoTCoreRequest;
import software.amazon.awssdk.aws.greengrass.model.PublishToIoTCoreResponse;
import software.amazon.awssdk.aws.greengrass.model.PublishToTopicRequest;
import software.amazon.awssdk.aws.greengrass.model.PublishToTopicResponse;
import software.amazon.awssdk.aws.greengrass.model.PutComponentMetricRequest;
import software.amazon.awssdk.aws.greengrass.model.PutComponentMetricResponse;
import software.amazon.awssdk.aws.greengrass.model.RestartComponentRequest;
import software.amazon.awssdk.aws.greengrass.model.RestartComponentResponse;
import software.amazon.awssdk.aws.greengrass.model.ResumeComponentRequest;
import software.amazon.awssdk.aws.greengrass.model.ResumeComponentResponse;
import software.amazon.awssdk.aws.greengrass.model.SendConfigurationValidityReportRequest;
import software.amazon.awssdk.aws.greengrass.model.SendConfigurationValidityReportResponse;
import software.amazon.awssdk.aws.greengrass.model.StopComponentRequest;
import software.amazon.awssdk.aws.greengrass.model.StopComponentResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToCertificateUpdatesRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToCertificateUpdatesResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToComponentUpdatesRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToComponentUpdatesResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToConfigurationUpdateRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToConfigurationUpdateResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToIoTCoreRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToIoTCoreResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToTopicRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToTopicResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToValidateConfigurationUpdatesRequest;
import software.amazon.awssdk.aws.greengrass.model.SubscribeToValidateConfigurationUpdatesResponse;
import software.amazon.awssdk.aws.greengrass.model.SubscriptionResponseMessage;
import software.amazon.awssdk.aws.greengrass.model.UpdateConfigurationRequest;
import software.amazon.awssdk.aws.greengrass.model.UpdateConfigurationResponse;
import software.amazon.awssdk.aws.greengrass.model.UpdateStateRequest;
import software.amazon.awssdk.aws.greengrass.model.UpdateStateResponse;
import software.amazon.awssdk.aws.greengrass.model.UpdateThingShadowRequest;
import software.amazon.awssdk.aws.greengrass.model.UpdateThingShadowResponse;
import software.amazon.awssdk.aws.greengrass.model.ValidateAuthorizationTokenRequest;
import software.amazon.awssdk.aws.greengrass.model.ValidateAuthorizationTokenResponse;
import software.amazon.awssdk.aws.greengrass.model.ValidateConfigurationUpdateEvents;
import software.amazon.awssdk.aws.greengrass.model.VerifyClientDeviceIdentityRequest;
import software.amazon.awssdk.aws.greengrass.model.VerifyClientDeviceIdentityResponse;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCConnection;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCConnectionConfig;
import software.amazon.awssdk.eventstreamrpc.GreengrassConnectMessageSupplier;
import software.amazon.awssdk.eventstreamrpc.StreamResponseHandler;

public class GreengrassCoreIPCClientV2
implements AutoCloseable {
    protected GreengrassCoreIPC client;
    protected Executor executor;
    protected EventStreamRPCConnection connection;

    GreengrassCoreIPCClientV2(GreengrassCoreIPC client, EventStreamRPCConnection connection, Executor executor) {
        this.client = client;
        this.connection = connection;
        this.executor = executor;
    }

    @Override
    public void close() throws Exception {
        if (this.client instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.client)).close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public GreengrassCoreIPC getClient() {
        return this.client;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AuthorizeClientDeviceActionResponse authorizeClientDeviceAction(AuthorizeClientDeviceActionRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.authorizeClientDeviceActionAsync(request));
    }

    public CompletableFuture<AuthorizeClientDeviceActionResponse> authorizeClientDeviceActionAsync(AuthorizeClientDeviceActionRequest request) {
        return this.client.authorizeClientDeviceAction(request, Optional.empty()).getResponse();
    }

    public CreateDebugPasswordResponse createDebugPassword(CreateDebugPasswordRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.createDebugPasswordAsync(request));
    }

    public CompletableFuture<CreateDebugPasswordResponse> createDebugPasswordAsync(CreateDebugPasswordRequest request) {
        return this.client.createDebugPassword(request, Optional.empty()).getResponse();
    }

    public CreateLocalDeploymentResponse createLocalDeployment(CreateLocalDeploymentRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.createLocalDeploymentAsync(request));
    }

    public CompletableFuture<CreateLocalDeploymentResponse> createLocalDeploymentAsync(CreateLocalDeploymentRequest request) {
        return this.client.createLocalDeployment(request, Optional.empty()).getResponse();
    }

    public DeferComponentUpdateResponse deferComponentUpdate(DeferComponentUpdateRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.deferComponentUpdateAsync(request));
    }

    public CompletableFuture<DeferComponentUpdateResponse> deferComponentUpdateAsync(DeferComponentUpdateRequest request) {
        return this.client.deferComponentUpdate(request, Optional.empty()).getResponse();
    }

    public DeleteThingShadowResponse deleteThingShadow(DeleteThingShadowRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.deleteThingShadowAsync(request));
    }

    public CompletableFuture<DeleteThingShadowResponse> deleteThingShadowAsync(DeleteThingShadowRequest request) {
        return this.client.deleteThingShadow(request, Optional.empty()).getResponse();
    }

    public GetClientDeviceAuthTokenResponse getClientDeviceAuthToken(GetClientDeviceAuthTokenRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getClientDeviceAuthTokenAsync(request));
    }

    public CompletableFuture<GetClientDeviceAuthTokenResponse> getClientDeviceAuthTokenAsync(GetClientDeviceAuthTokenRequest request) {
        return this.client.getClientDeviceAuthToken(request, Optional.empty()).getResponse();
    }

    public GetComponentDetailsResponse getComponentDetails(GetComponentDetailsRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getComponentDetailsAsync(request));
    }

    public CompletableFuture<GetComponentDetailsResponse> getComponentDetailsAsync(GetComponentDetailsRequest request) {
        return this.client.getComponentDetails(request, Optional.empty()).getResponse();
    }

    public GetConfigurationResponse getConfiguration(GetConfigurationRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getConfigurationAsync(request));
    }

    public CompletableFuture<GetConfigurationResponse> getConfigurationAsync(GetConfigurationRequest request) {
        return this.client.getConfiguration(request, Optional.empty()).getResponse();
    }

    public GetLocalDeploymentStatusResponse getLocalDeploymentStatus(GetLocalDeploymentStatusRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getLocalDeploymentStatusAsync(request));
    }

    public CompletableFuture<GetLocalDeploymentStatusResponse> getLocalDeploymentStatusAsync(GetLocalDeploymentStatusRequest request) {
        return this.client.getLocalDeploymentStatus(request, Optional.empty()).getResponse();
    }

    public GetSecretValueResponse getSecretValue(GetSecretValueRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getSecretValueAsync(request));
    }

    public CompletableFuture<GetSecretValueResponse> getSecretValueAsync(GetSecretValueRequest request) {
        return this.client.getSecretValue(request, Optional.empty()).getResponse();
    }

    public GetThingShadowResponse getThingShadow(GetThingShadowRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.getThingShadowAsync(request));
    }

    public CompletableFuture<GetThingShadowResponse> getThingShadowAsync(GetThingShadowRequest request) {
        return this.client.getThingShadow(request, Optional.empty()).getResponse();
    }

    public ListComponentsResponse listComponents(ListComponentsRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.listComponentsAsync(request));
    }

    public CompletableFuture<ListComponentsResponse> listComponentsAsync(ListComponentsRequest request) {
        return this.client.listComponents(request, Optional.empty()).getResponse();
    }

    public ListLocalDeploymentsResponse listLocalDeployments(ListLocalDeploymentsRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.listLocalDeploymentsAsync(request));
    }

    public CompletableFuture<ListLocalDeploymentsResponse> listLocalDeploymentsAsync(ListLocalDeploymentsRequest request) {
        return this.client.listLocalDeployments(request, Optional.empty()).getResponse();
    }

    public ListNamedShadowsForThingResponse listNamedShadowsForThing(ListNamedShadowsForThingRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.listNamedShadowsForThingAsync(request));
    }

    public CompletableFuture<ListNamedShadowsForThingResponse> listNamedShadowsForThingAsync(ListNamedShadowsForThingRequest request) {
        return this.client.listNamedShadowsForThing(request, Optional.empty()).getResponse();
    }

    public PauseComponentResponse pauseComponent(PauseComponentRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.pauseComponentAsync(request));
    }

    public CompletableFuture<PauseComponentResponse> pauseComponentAsync(PauseComponentRequest request) {
        return this.client.pauseComponent(request, Optional.empty()).getResponse();
    }

    public PublishToIoTCoreResponse publishToIoTCore(PublishToIoTCoreRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.publishToIoTCoreAsync(request));
    }

    public CompletableFuture<PublishToIoTCoreResponse> publishToIoTCoreAsync(PublishToIoTCoreRequest request) {
        return this.client.publishToIoTCore(request, Optional.empty()).getResponse();
    }

    public PublishToTopicResponse publishToTopic(PublishToTopicRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.publishToTopicAsync(request));
    }

    public CompletableFuture<PublishToTopicResponse> publishToTopicAsync(PublishToTopicRequest request) {
        return this.client.publishToTopic(request, Optional.empty()).getResponse();
    }

    public PutComponentMetricResponse putComponentMetric(PutComponentMetricRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.putComponentMetricAsync(request));
    }

    public CompletableFuture<PutComponentMetricResponse> putComponentMetricAsync(PutComponentMetricRequest request) {
        return this.client.putComponentMetric(request, Optional.empty()).getResponse();
    }

    public RestartComponentResponse restartComponent(RestartComponentRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.restartComponentAsync(request));
    }

    public CompletableFuture<RestartComponentResponse> restartComponentAsync(RestartComponentRequest request) {
        return this.client.restartComponent(request, Optional.empty()).getResponse();
    }

    public ResumeComponentResponse resumeComponent(ResumeComponentRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.resumeComponentAsync(request));
    }

    public CompletableFuture<ResumeComponentResponse> resumeComponentAsync(ResumeComponentRequest request) {
        return this.client.resumeComponent(request, Optional.empty()).getResponse();
    }

    public SendConfigurationValidityReportResponse sendConfigurationValidityReport(SendConfigurationValidityReportRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.sendConfigurationValidityReportAsync(request));
    }

    public CompletableFuture<SendConfigurationValidityReportResponse> sendConfigurationValidityReportAsync(SendConfigurationValidityReportRequest request) {
        return this.client.sendConfigurationValidityReport(request, Optional.empty()).getResponse();
    }

    public StopComponentResponse stopComponent(StopComponentRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.stopComponentAsync(request));
    }

    public CompletableFuture<StopComponentResponse> stopComponentAsync(StopComponentRequest request) {
        return this.client.stopComponent(request, Optional.empty()).getResponse();
    }

    public StreamingResponse<CompletableFuture<SubscribeToCertificateUpdatesResponse>, SubscribeToCertificateUpdatesResponseHandler> subscribeToCertificateUpdatesAsync(SubscribeToCertificateUpdatesRequest request, Consumer<CertificateUpdateEvent> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToCertificateUpdatesAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToCertificateUpdatesResponse, SubscribeToCertificateUpdatesResponseHandler> subscribeToCertificateUpdates(SubscribeToCertificateUpdatesRequest request, Consumer<CertificateUpdateEvent> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToCertificateUpdatesResponse>, SubscribeToCertificateUpdatesResponseHandler> r = this.subscribeToCertificateUpdatesAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToCertificateUpdatesResponse, SubscribeToCertificateUpdatesResponseHandler>((SubscribeToCertificateUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToCertificateUpdatesResponse, SubscribeToCertificateUpdatesResponseHandler> subscribeToCertificateUpdates(SubscribeToCertificateUpdatesRequest request, StreamResponseHandler<CertificateUpdateEvent> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToCertificateUpdatesResponse>, SubscribeToCertificateUpdatesResponseHandler> r = this.subscribeToCertificateUpdatesAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToCertificateUpdatesResponse, SubscribeToCertificateUpdatesResponseHandler>((SubscribeToCertificateUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToCertificateUpdatesResponse>, SubscribeToCertificateUpdatesResponseHandler> subscribeToCertificateUpdatesAsync(SubscribeToCertificateUpdatesRequest request, StreamResponseHandler<CertificateUpdateEvent> streamResponseHandler) {
        SubscribeToCertificateUpdatesResponseHandler r = this.client.subscribeToCertificateUpdates(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToCertificateUpdatesResponse>, SubscribeToCertificateUpdatesResponseHandler>(r.getResponse(), r);
    }

    public StreamingResponse<CompletableFuture<SubscribeToComponentUpdatesResponse>, SubscribeToComponentUpdatesResponseHandler> subscribeToComponentUpdatesAsync(SubscribeToComponentUpdatesRequest request, Consumer<ComponentUpdatePolicyEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToComponentUpdatesAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToComponentUpdatesResponse, SubscribeToComponentUpdatesResponseHandler> subscribeToComponentUpdates(SubscribeToComponentUpdatesRequest request, Consumer<ComponentUpdatePolicyEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToComponentUpdatesResponse>, SubscribeToComponentUpdatesResponseHandler> r = this.subscribeToComponentUpdatesAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToComponentUpdatesResponse, SubscribeToComponentUpdatesResponseHandler>((SubscribeToComponentUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToComponentUpdatesResponse, SubscribeToComponentUpdatesResponseHandler> subscribeToComponentUpdates(SubscribeToComponentUpdatesRequest request, StreamResponseHandler<ComponentUpdatePolicyEvents> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToComponentUpdatesResponse>, SubscribeToComponentUpdatesResponseHandler> r = this.subscribeToComponentUpdatesAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToComponentUpdatesResponse, SubscribeToComponentUpdatesResponseHandler>((SubscribeToComponentUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToComponentUpdatesResponse>, SubscribeToComponentUpdatesResponseHandler> subscribeToComponentUpdatesAsync(SubscribeToComponentUpdatesRequest request, StreamResponseHandler<ComponentUpdatePolicyEvents> streamResponseHandler) {
        SubscribeToComponentUpdatesResponseHandler r = this.client.subscribeToComponentUpdates(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToComponentUpdatesResponse>, SubscribeToComponentUpdatesResponseHandler>(r.getResponse(), r);
    }

    public StreamingResponse<CompletableFuture<SubscribeToConfigurationUpdateResponse>, SubscribeToConfigurationUpdateResponseHandler> subscribeToConfigurationUpdateAsync(SubscribeToConfigurationUpdateRequest request, Consumer<ConfigurationUpdateEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToConfigurationUpdateAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToConfigurationUpdateResponse, SubscribeToConfigurationUpdateResponseHandler> subscribeToConfigurationUpdate(SubscribeToConfigurationUpdateRequest request, Consumer<ConfigurationUpdateEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToConfigurationUpdateResponse>, SubscribeToConfigurationUpdateResponseHandler> r = this.subscribeToConfigurationUpdateAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToConfigurationUpdateResponse, SubscribeToConfigurationUpdateResponseHandler>((SubscribeToConfigurationUpdateResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToConfigurationUpdateResponse, SubscribeToConfigurationUpdateResponseHandler> subscribeToConfigurationUpdate(SubscribeToConfigurationUpdateRequest request, StreamResponseHandler<ConfigurationUpdateEvents> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToConfigurationUpdateResponse>, SubscribeToConfigurationUpdateResponseHandler> r = this.subscribeToConfigurationUpdateAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToConfigurationUpdateResponse, SubscribeToConfigurationUpdateResponseHandler>((SubscribeToConfigurationUpdateResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToConfigurationUpdateResponse>, SubscribeToConfigurationUpdateResponseHandler> subscribeToConfigurationUpdateAsync(SubscribeToConfigurationUpdateRequest request, StreamResponseHandler<ConfigurationUpdateEvents> streamResponseHandler) {
        SubscribeToConfigurationUpdateResponseHandler r = this.client.subscribeToConfigurationUpdate(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToConfigurationUpdateResponse>, SubscribeToConfigurationUpdateResponseHandler>(r.getResponse(), r);
    }

    public StreamingResponse<CompletableFuture<SubscribeToIoTCoreResponse>, SubscribeToIoTCoreResponseHandler> subscribeToIoTCoreAsync(SubscribeToIoTCoreRequest request, Consumer<IoTCoreMessage> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToIoTCoreAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToIoTCoreResponse, SubscribeToIoTCoreResponseHandler> subscribeToIoTCore(SubscribeToIoTCoreRequest request, Consumer<IoTCoreMessage> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToIoTCoreResponse>, SubscribeToIoTCoreResponseHandler> r = this.subscribeToIoTCoreAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToIoTCoreResponse, SubscribeToIoTCoreResponseHandler>((SubscribeToIoTCoreResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToIoTCoreResponse, SubscribeToIoTCoreResponseHandler> subscribeToIoTCore(SubscribeToIoTCoreRequest request, StreamResponseHandler<IoTCoreMessage> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToIoTCoreResponse>, SubscribeToIoTCoreResponseHandler> r = this.subscribeToIoTCoreAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToIoTCoreResponse, SubscribeToIoTCoreResponseHandler>((SubscribeToIoTCoreResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToIoTCoreResponse>, SubscribeToIoTCoreResponseHandler> subscribeToIoTCoreAsync(SubscribeToIoTCoreRequest request, StreamResponseHandler<IoTCoreMessage> streamResponseHandler) {
        SubscribeToIoTCoreResponseHandler r = this.client.subscribeToIoTCore(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToIoTCoreResponse>, SubscribeToIoTCoreResponseHandler>(r.getResponse(), r);
    }

    public StreamingResponse<CompletableFuture<SubscribeToTopicResponse>, SubscribeToTopicResponseHandler> subscribeToTopicAsync(SubscribeToTopicRequest request, Consumer<SubscriptionResponseMessage> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToTopicAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToTopicResponse, SubscribeToTopicResponseHandler> subscribeToTopic(SubscribeToTopicRequest request, Consumer<SubscriptionResponseMessage> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToTopicResponse>, SubscribeToTopicResponseHandler> r = this.subscribeToTopicAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToTopicResponse, SubscribeToTopicResponseHandler>((SubscribeToTopicResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToTopicResponse, SubscribeToTopicResponseHandler> subscribeToTopic(SubscribeToTopicRequest request, StreamResponseHandler<SubscriptionResponseMessage> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToTopicResponse>, SubscribeToTopicResponseHandler> r = this.subscribeToTopicAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToTopicResponse, SubscribeToTopicResponseHandler>((SubscribeToTopicResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToTopicResponse>, SubscribeToTopicResponseHandler> subscribeToTopicAsync(SubscribeToTopicRequest request, StreamResponseHandler<SubscriptionResponseMessage> streamResponseHandler) {
        SubscribeToTopicResponseHandler r = this.client.subscribeToTopic(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToTopicResponse>, SubscribeToTopicResponseHandler>(r.getResponse(), r);
    }

    public StreamingResponse<CompletableFuture<SubscribeToValidateConfigurationUpdatesResponse>, SubscribeToValidateConfigurationUpdatesResponseHandler> subscribeToValidateConfigurationUpdatesAsync(SubscribeToValidateConfigurationUpdatesRequest request, Consumer<ValidateConfigurationUpdateEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) {
        return this.subscribeToValidateConfigurationUpdatesAsync(request, this.getStreamingResponseHandler(onStreamEvent, onStreamError, onStreamClosed));
    }

    public StreamingResponse<SubscribeToValidateConfigurationUpdatesResponse, SubscribeToValidateConfigurationUpdatesResponseHandler> subscribeToValidateConfigurationUpdates(SubscribeToValidateConfigurationUpdatesRequest request, Consumer<ValidateConfigurationUpdateEvents> onStreamEvent, Optional<Function<Throwable, Boolean>> onStreamError, Optional<Runnable> onStreamClosed) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToValidateConfigurationUpdatesResponse>, SubscribeToValidateConfigurationUpdatesResponseHandler> r = this.subscribeToValidateConfigurationUpdatesAsync(request, onStreamEvent, onStreamError, onStreamClosed);
        return new StreamingResponse<SubscribeToValidateConfigurationUpdatesResponse, SubscribeToValidateConfigurationUpdatesResponseHandler>((SubscribeToValidateConfigurationUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<SubscribeToValidateConfigurationUpdatesResponse, SubscribeToValidateConfigurationUpdatesResponseHandler> subscribeToValidateConfigurationUpdates(SubscribeToValidateConfigurationUpdatesRequest request, StreamResponseHandler<ValidateConfigurationUpdateEvents> streamResponseHandler) throws InterruptedException {
        StreamingResponse<CompletableFuture<SubscribeToValidateConfigurationUpdatesResponse>, SubscribeToValidateConfigurationUpdatesResponseHandler> r = this.subscribeToValidateConfigurationUpdatesAsync(request, streamResponseHandler);
        return new StreamingResponse<SubscribeToValidateConfigurationUpdatesResponse, SubscribeToValidateConfigurationUpdatesResponseHandler>((SubscribeToValidateConfigurationUpdatesResponse)GreengrassCoreIPCClientV2.getResponse(r.getResponse()), r.getHandler());
    }

    public StreamingResponse<CompletableFuture<SubscribeToValidateConfigurationUpdatesResponse>, SubscribeToValidateConfigurationUpdatesResponseHandler> subscribeToValidateConfigurationUpdatesAsync(SubscribeToValidateConfigurationUpdatesRequest request, StreamResponseHandler<ValidateConfigurationUpdateEvents> streamResponseHandler) {
        SubscribeToValidateConfigurationUpdatesResponseHandler r = this.client.subscribeToValidateConfigurationUpdates(request, Optional.ofNullable(this.getStreamingResponseHandler(streamResponseHandler)));
        return new StreamingResponse<CompletableFuture<SubscribeToValidateConfigurationUpdatesResponse>, SubscribeToValidateConfigurationUpdatesResponseHandler>(r.getResponse(), r);
    }

    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.updateConfigurationAsync(request));
    }

    public CompletableFuture<UpdateConfigurationResponse> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.client.updateConfiguration(request, Optional.empty()).getResponse();
    }

    public UpdateStateResponse updateState(UpdateStateRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.updateStateAsync(request));
    }

    public CompletableFuture<UpdateStateResponse> updateStateAsync(UpdateStateRequest request) {
        return this.client.updateState(request, Optional.empty()).getResponse();
    }

    public UpdateThingShadowResponse updateThingShadow(UpdateThingShadowRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.updateThingShadowAsync(request));
    }

    public CompletableFuture<UpdateThingShadowResponse> updateThingShadowAsync(UpdateThingShadowRequest request) {
        return this.client.updateThingShadow(request, Optional.empty()).getResponse();
    }

    public ValidateAuthorizationTokenResponse validateAuthorizationToken(ValidateAuthorizationTokenRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.validateAuthorizationTokenAsync(request));
    }

    public CompletableFuture<ValidateAuthorizationTokenResponse> validateAuthorizationTokenAsync(ValidateAuthorizationTokenRequest request) {
        return this.client.validateAuthorizationToken(request, Optional.empty()).getResponse();
    }

    public VerifyClientDeviceIdentityResponse verifyClientDeviceIdentity(VerifyClientDeviceIdentityRequest request) throws InterruptedException {
        return GreengrassCoreIPCClientV2.getResponse(this.verifyClientDeviceIdentityAsync(request));
    }

    public CompletableFuture<VerifyClientDeviceIdentityResponse> verifyClientDeviceIdentityAsync(VerifyClientDeviceIdentityRequest request) {
        return this.client.verifyClientDeviceIdentity(request, Optional.empty()).getResponse();
    }

    protected static <T> T getResponse(Future<T> fut) throws InterruptedException {
        try {
            return fut.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    protected <T> StreamResponseHandler<T> getStreamingResponseHandler(final StreamResponseHandler<T> h) {
        if (h == null || this.executor == null) {
            return h;
        }
        return new StreamResponseHandler<T>(){

            @Override
            public void onStreamEvent(T event) {
                GreengrassCoreIPCClientV2.this.executor.execute(() -> h.onStreamEvent(event));
            }

            @Override
            public boolean onStreamError(Throwable error) {
                return h.onStreamError(error);
            }

            @Override
            public void onStreamClosed() {
                GreengrassCoreIPCClientV2.this.executor.execute(h::onStreamClosed);
            }
        };
    }

    protected <T> StreamResponseHandler<T> getStreamingResponseHandler(final Consumer<T> onStreamEvent, final Optional<Function<Throwable, Boolean>> onStreamError, final Optional<Runnable> onStreamClosed) {
        return new StreamResponseHandler<T>(){

            @Override
            public void onStreamEvent(T event) {
                onStreamEvent.accept(event);
            }

            @Override
            public boolean onStreamError(Throwable error) {
                if (onStreamError != null && onStreamError.isPresent()) {
                    return (Boolean)((Function)onStreamError.get()).apply(error);
                }
                return true;
            }

            @Override
            public void onStreamClosed() {
                if (onStreamClosed != null && onStreamClosed.isPresent()) {
                    ((Runnable)onStreamClosed.get()).run();
                }
            }
        };
    }

    public static class Builder {
        protected GreengrassCoreIPC client;
        protected Executor executor;
        protected boolean useExecutor = true;
        protected String socketPath = System.getenv("AWS_GG_NUCLEUS_DOMAIN_SOCKET_FILEPATH_FOR_COMPONENT");
        protected String authToken = System.getenv("SVCUID");
        protected int port = 8888;
        protected EventStreamRPCConnection connection = null;
        protected SocketOptions.SocketDomain socketDomain = SocketOptions.SocketDomain.LOCAL;

        public GreengrassCoreIPCClientV2 build() throws IOException {
            if (this.client == null) {
                String ipcServerSocketPath = this.socketPath;
                String authToken = this.authToken;
                try (EventLoopGroup elGroup = new EventLoopGroup(1);
                     ClientBootstrap clientBootstrap = new ClientBootstrap(elGroup, null);
                     SocketOptions socketOptions = new SocketOptions();){
                    socketOptions.connectTimeoutMs = 3000;
                    socketOptions.domain = this.socketDomain;
                    socketOptions.type = SocketOptions.SocketType.STREAM;
                    EventStreamRPCConnectionConfig config = new EventStreamRPCConnectionConfig(clientBootstrap, elGroup, socketOptions, null, ipcServerSocketPath, this.port, GreengrassConnectMessageSupplier.connectMessageSupplier(authToken));
                    this.connection = new EventStreamRPCConnection(config);
                    final CompletableFuture connected = new CompletableFuture();
                    this.connection.connect(new EventStreamRPCConnection.LifecycleHandler(){

                        @Override
                        public void onConnect() {
                            connected.complete(null);
                        }

                        @Override
                        public void onDisconnect(int errorCode) {
                        }

                        @Override
                        public boolean onError(Throwable t) {
                            connected.completeExceptionally(t);
                            return true;
                        }
                    });
                    try {
                        connected.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.connection.close();
                        throw new IOException(e);
                    }
                    this.client = new GreengrassCoreIPCClient(this.connection);
                }
            }
            if (this.useExecutor && this.executor == null) {
                this.executor = Executors.newCachedThreadPool();
            }
            return new GreengrassCoreIPCClientV2(this.client, this.connection, this.executor);
        }

        public Builder withClient(GreengrassCoreIPC client) {
            this.client = client;
            return this;
        }

        public Builder withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder withSocketPath(String socketPath) {
            this.socketPath = socketPath;
            return this;
        }

        public Builder withSocketDomain(SocketOptions.SocketDomain domain) {
            this.socketDomain = domain;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.useExecutor = true;
            this.executor = executor;
            return this;
        }

        public Builder withoutExecutor() {
            this.useExecutor = false;
            this.executor = null;
            return this;
        }
    }

    public static class StreamingResponse<T, U> {
        protected final T r;
        protected final U h;

        public StreamingResponse(T r, U h) {
            this.r = r;
            this.h = h;
        }

        public T getResponse() {
            return this.r;
        }

        public U getHandler() {
            return this.h;
        }
    }
}

