/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class CertificateUpdate
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#CertificateUpdate";
    public static final CertificateUpdate VOID = new CertificateUpdate(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> privateKey = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> publicKey = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> certificate = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<List<String>> caCertificates = Optional.empty();

    public String getPrivateKey() {
        if (this.privateKey.isPresent()) {
            return this.privateKey.get();
        }
        return null;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = Optional.ofNullable(privateKey);
    }

    public CertificateUpdate withPrivateKey(String privateKey) {
        this.setPrivateKey(privateKey);
        return this;
    }

    public String getPublicKey() {
        if (this.publicKey.isPresent()) {
            return this.publicKey.get();
        }
        return null;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.ofNullable(publicKey);
    }

    public CertificateUpdate withPublicKey(String publicKey) {
        this.setPublicKey(publicKey);
        return this;
    }

    public String getCertificate() {
        if (this.certificate.isPresent()) {
            return this.certificate.get();
        }
        return null;
    }

    public void setCertificate(String certificate) {
        this.certificate = Optional.ofNullable(certificate);
    }

    public CertificateUpdate withCertificate(String certificate) {
        this.setCertificate(certificate);
        return this;
    }

    public List<String> getCaCertificates() {
        if (this.caCertificates.isPresent()) {
            return this.caCertificates.get();
        }
        return null;
    }

    public void setCaCertificates(List<String> caCertificates) {
        this.caCertificates = Optional.ofNullable(caCertificates);
    }

    public CertificateUpdate withCaCertificates(List<String> caCertificates) {
        this.setCaCertificates(caCertificates);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof CertificateUpdate)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        CertificateUpdate other = (CertificateUpdate)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.privateKey.equals(other.privateKey);
        isEquals = isEquals && this.publicKey.equals(other.publicKey);
        isEquals = isEquals && this.certificate.equals(other.certificate);
        isEquals = isEquals && this.caCertificates.equals(other.caCertificates);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.publicKey, this.certificate, this.caCertificates);
    }
}

